/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.objects.IBufferUsage;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.controllers.BuffersViewController;
import com.arm.mgd.ui.controllers.BuffersViewItem;
import com.arm.mgd.ui.controllers.commands.Commands;
import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.controllers.commands.ICommandDispatcher;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.utils.FunctionStringConverter;
import com.arm.mgd.ui.views.BinaryDataView;
import com.arm.mgd.ui.views.BinaryDataViewController;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BuffersView
extends FXViewPart {
    private BuffersViewController buffersViewController = null;
    private BinaryDataViewController binaryDataViewController = null;
    @FXML
    private Control rootContainer;
    @FXML
    private VBox vbox;
    @FXML
    private TableView<BuffersViewItem> tableView;
    @FXML
    private TableColumn<BuffersViewItem, BuffersViewItem.BufferName> bufferColumn;
    @FXML
    private TableColumn<BuffersViewItem, Integer> sizeColumn;
    @FXML
    private TableColumn<BuffersViewItem, IBufferUsage> usageColumn;
    @FXML
    private TableColumn<BuffersViewItem, AbstractConstantOrAliasSpecExtended> lastBoundTargetColumn;
    @FXML
    private Label buffersMemoryUsageLabel;
    @FXML
    private TextField filterTextField;
    @FXML
    private BinaryDataView binaryDataView;

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/buffersView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (Control)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.buffersViewController = new BuffersViewController(this.visibleProperty());
        this.binaryDataViewController = new BinaryDataViewController();
        this.bufferColumn.setCellValueFactory((Callback)new PropertyValueFactory("bufferName"));
        this.sizeColumn.setCellValueFactory((Callback)new PropertyValueFactory("size"));
        this.lastBoundTargetColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastBoundTarget"));
        this.usageColumn.setCellValueFactory((Callback)new PropertyValueFactory("usage"));
        this.bufferColumn.setCellFactory(TextFieldTableCell.forTableColumn(new FunctionStringConverter<BuffersViewItem.BufferName>(item -> item.getName())));
        this.usageColumn.setCellFactory(TextFieldTableCell.forTableColumn(new FunctionStringConverter<IBufferUsage>(item -> {
            if (item != null) {
                return item.getLabelText();
            }
            return null;
        })));
        this.lastBoundTargetColumn.setCellFactory(TextFieldTableCell.forTableColumn(new FunctionStringConverter<AbstractConstantOrAliasSpecExtended>(item -> {
            if (item != null) {
                return item.getName();
            }
            return null;
        })));
        Tooltip filterTextTooltip = new Tooltip();
        filterTextTooltip.textProperty().bind((ObservableValue)this.buffersViewController.filterPatternContextMessageProperty());
        this.filterTextField.tooltipProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.buffersViewController.filterPatternContextMessageProperty().get() != null ? filterTextTooltip : null, (Observable[])new Observable[]{this.buffersViewController.filterPatternContextMessageProperty()}));
        PseudoClass invalidClass = PseudoClass.getPseudoClass((String)"invalid");
        this.buffersViewController.filterPatternIsValidProperty().addListener((observable, oldValue, newValue) -> this.filterTextField.pseudoClassStateChanged(invalidClass, newValue == false));
        this.buffersViewController.bindComparatorProperty(this.tableView.comparatorProperty());
        this.buffersViewController.bindSelectedIndices((ObservableList<Integer>)this.tableView.getSelectionModel().getSelectedIndices());
        this.buffersViewController.bindFilterText(this.filterTextField.textProperty());
        this.buffersMemoryUsageLabel.textProperty().bind((ObservableValue)this.buffersViewController.getBuffersMemoryUsageMessage());
        this.tableView.setItems(this.buffersViewController.getItemList());
        this.tableView.setTableMenuButtonVisible(true);
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableView.getSortOrder().add(this.bufferColumn);
        this.loadBuffersViewContextMenu();
        this.binaryDataViewController.noOfBytesPerRowProperty().bind((ObservableValue)this.binaryDataView.noOfBytesPerRowProperty());
        this.binaryDataViewController.bindComparatorProperty(this.binaryDataView.comparatorProperty());
        this.binaryDataViewController.bindSelectedIndices((ObservableList<Integer>)this.binaryDataView.getSelectionModel().getSelectedIndices());
        this.binaryDataView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.binaryDataView.setupView();
        this.binaryDataView.setItems(this.binaryDataViewController.getItemList());
        this.binaryDataView.loadContextMenu((BinaryDataViewController)NullUtils.neverNull((Object)this.binaryDataViewController));
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            IBufferItem item = newValue != null ? newValue.getBufferAsset() : null;
            this.binaryDataViewController.bufferItemProperty().set((Object)item);
        });
        return new Scene((Parent)this.rootContainer);
    }

    @Override
    public void dispose() {
        this.buffersViewController.dispose();
        this.buffersViewController = null;
        super.dispose();
    }

    @Override
    protected void setFxFocus() {
        this.filterTextField.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.buffersview";
    }

    private void loadBuffersViewContextMenu() {
        HashMap<@NonNull ICommand<? super BuffersViewItem>, @NonNull MenuItem> allMenuItems = new HashMap<ICommand<? super BuffersViewItem>, MenuItem>();
        ContextMenu contextMenu = new ContextMenu();
        allMenuItems.put(Commands.EXPORT_SELECTED_BUFFERS_COMMAND, ContextMenuHelper.addItem(contextMenu, (ICommandDispatcher)NullUtils.neverNull((Object)this.buffersViewController), Commands.EXPORT_SELECTED_BUFFERS_COMMAND));
        allMenuItems.put(Commands.SHOW_CREATED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, (ICommandDispatcher)NullUtils.neverNull((Object)this.buffersViewController), Commands.SHOW_CREATED_LOCATION_COMMAND));
        allMenuItems.put(Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND, ContextMenuHelper.addItem(contextMenu, (ICommandDispatcher)NullUtils.neverNull((Object)this.buffersViewController), Commands.SHOW_LAST_MODIFIED_LOCATION_COMMAND));
        allMenuItems.put(this.buffersViewController.getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (ICommandDispatcher)NullUtils.neverNull((Object)this.buffersViewController), this.buffersViewController.getCopyCommand()));
        KeyCodeCombination combo = new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN});
        this.tableView.addEventFilter(KeyEvent.ANY, arg_0 -> this.lambda$6((KeyCombination)combo, arg_0));
        contextMenu.showingProperty().addListener(listener -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!this.buffersViewController.canDispatchCommand(command))));
        BuffersView.loadContextMenuItems(this.tableView, contextMenu, allMenuItems, this.buffersViewController);
    }

    private static void loadContextMenuItems(Control control, @NonNull ContextMenu contextMenu, Map<@NonNull ICommand<? super BuffersViewItem>, @NonNull MenuItem> allMenuItems, ICommandDispatcher<BuffersViewItem> dispatcher) {
        assert (control != null);
        contextMenu.showingProperty().addListener(listener -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!dispatcher.canDispatchCommand((ICommand<BuffersViewItem>)command))));
        ContextMenuHelper.setContextMenu((Node)control, contextMenu);
    }

    private /* synthetic */ void lambda$6(KeyCombination keyCombination, KeyEvent event) {
        if (keyCombination.match(event)) {
            this.buffersViewController.dispatchCommand(this.buffersViewController.getCopyCommand());
        }
    }
}

