/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.BookmarksViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.views.widgets.CommitOnFocusLostTextFieldTableCell;
import com.arm.mgd.ui.views.widgets.TableHeaderTooltip;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BookmarksView
extends FXViewPart {
    @FXML
    private TableView<@NonNull BookmarksViewController.BookmarksViewItem> tableView;
    @FXML
    private TableColumn<@NonNull BookmarksViewController.BookmarksViewItem, @NonNull Integer> functionCallColumn;
    @FXML
    private TableColumn<@NonNull BookmarksViewController.BookmarksViewItem, @NonNull String> descriptionColumn;
    @FXML
    private TableColumn<@NonNull BookmarksViewController.BookmarksViewItem, @NonNull Integer> buttonColumn;
    @FXML
    private Button addButton;
    @FXML
    private Button removeButton;
    private final @NonNull BookmarksViewController controller = new BookmarksViewController(this.visibleProperty());

    @Override
    public void dispose() {
        this.controller.close();
        super.dispose();
    }

    @Override
    protected Scene createFxScene() {
        VBox rootContainer;
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/bookmarksView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            rootContainer = (VBox)fxmlLoader.load();
        }
        catch (IOException e2) {
            CoreLogging.severe((Throwable)e2);
            return null;
        }
        this.functionCallColumn.setCellValueFactory(p -> new SimpleObjectProperty((Object)NullUtils.intValueOf((int)((BookmarksViewController.BookmarksViewItem)p.getValue()).getIndex())));
        TableHeaderTooltip.makeHeaderWithTooltip(this.functionCallColumn, "The function call ID of the bookmark.");
        this.descriptionColumn.setCellValueFactory(p -> ((BookmarksViewController.BookmarksViewItem)p.getValue()).getNote());
        TableHeaderTooltip.makeHeaderWithTooltip(this.descriptionColumn, "A description of the bookmark.");
        this.descriptionColumn.setCellFactory(param -> new CommitOnFocusLostTextFieldTableCell());
        this.descriptionColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<BookmarksViewController.BookmarksViewItem, String>>(){

            public void handle(// Could not load outer class - annotation placement on inner may be incorrect
            TableColumn.CellEditEvent<@NonNull BookmarksViewController.BookmarksViewItem, @NonNull String> event) {
                BookmarksViewController.BookmarksViewItem item = (BookmarksViewController.BookmarksViewItem)event.getRowValue();
                String newValue = (String)event.getNewValue();
                BookmarksView.this.controller.updateBookmark(item, newValue);
            }
        });
        this.buttonColumn.setCellValueFactory(p -> new SimpleObjectProperty((Object)NullUtils.intValueOf((int)((BookmarksViewController.BookmarksViewItem)p.getValue()).getIndex())));
        this.buttonColumn.setCellFactory((Callback)new Callback<TableColumn<BookmarksViewController.BookmarksViewItem, Integer>, TableCell<BookmarksViewController.BookmarksViewItem, Integer>>(){

            public TableCell<@NonNull BookmarksViewController.BookmarksViewItem, @NonNull Integer> call(TableColumn<@NonNull BookmarksViewController.BookmarksViewItem, @NonNull Integer> param) {
                TableCell<@NonNull BookmarksViewController.BookmarksViewItem, @NonNull Integer> cell = new TableCell<BookmarksViewController.BookmarksViewItem, Integer>(){
                    final Button button = new Button("Go to Function");

                    public void updateItem(final @NonNull Integer item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                            this.setText(null);
                        } else {
                            this.button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    ((this).this).BookmarksView.this.controller.navigateTo(item);
                                }
                            });
                            this.setGraphic((Node)this.button);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
        this.tableView.addEventFilter(KeyEvent.KEY_PRESSED, e -> this.tryRemoveButtonFire((KeyEvent)e));
        this.tableView.setItems(this.controller.getBookmarkViewItems());
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.addButton.disableProperty().bind(this.controller.addButtonDisabledProperty());
        this.addButton.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                BookmarksView.this.controller.addBookmarkAtCurrentNavigationLocation();
            }
        });
        BooleanBinding notemsSelected = Bindings.createBooleanBinding(() -> this.tableView.getSelectionModel().getSelectedItems().isEmpty(), (Observable[])new Observable[]{this.tableView.getSelectionModel().getSelectedItems()});
        this.removeButton.disableProperty().bind((ObservableValue)notemsSelected);
        this.removeButton.addEventHandler(ActionEvent.ACTION, event -> this.controller.removeBookmarks((Collection)NullUtils.neverNull((Object)this.tableView.getSelectionModel().getSelectedItems())));
        return new Scene((Parent)rootContainer);
    }

    @Override
    protected void setFxFocus() {
        this.tableView.requestFocus();
    }

    private void tryRemoveButtonFire(KeyEvent e) {
        if (e.getCode() == KeyCode.DELETE && !this.removeButton.isDisabled()) {
            this.removeButton.fire();
        }
    }

    @Override
    public @Nullable String getHelpId() {
        return "com.arm.mgd.help.bookmarksview";
    }
}

