/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.ui.controllers.IClipboardCopyable;
import com.arm.mgd.utils.NullUtils;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.ReadOnlyLongProperty;
import javafx.beans.property.ReadOnlyLongWrapper;
import javafx.collections.FXCollections;
import org.eclipse.jdt.annotation.NonNull;

public class BinaryDataViewItem
implements IClipboardCopyable {
    public static final String PROPERTY_ADDRESS = "address";
    public static final String PROPERTY_DATA = "data";
    private final ReadOnlyLongWrapper address;
    private final ReadOnlyListWrapper<Byte> data;

    public BinaryDataViewItem(long address, byte @NonNull [] data) {
        this.address = new ReadOnlyLongWrapper(address);
        this.data = new ReadOnlyListWrapper(FXCollections.observableArrayList());
        this.data.addAll((Collection)IntStream.range(0, data.length).mapToObj(n -> data[n]).collect(Collectors.toList()));
    }

    public final ReadOnlyLongProperty addressProperty() {
        return this.address.getReadOnlyProperty();
    }

    public final ReadOnlyListProperty<Byte> dataProperty() {
        return this.data.getReadOnlyProperty();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + String.format("0x%08X", this.address.getValue());
    }

    @Override
    public @NonNull String getClipboardContent() {
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add(String.format("0x%08X", this.address.getValue())).add(this.data.stream().map(b -> String.format("%02X", b)).collect(Collectors.joining(", ")));
        return (String)NullUtils.neverNull((Object)stringJoiner.toString());
    }
}

