/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.SimpleTableViewController;
import com.arm.mgd.ui.views.BinaryDataViewItem;
import com.arm.mgd.utils.NullUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.eclipse.jdt.annotation.NonNull;

public class BinaryDataViewController
extends SimpleTableViewController<BinaryDataViewItem> {
    private final @NonNull IntegerProperty noOfBytesPerRow;
    private final @NonNull SimpleObjectProperty<IBufferItem> bufferItem = new SimpleObjectProperty();

    public IntegerProperty noOfBytesPerRowProperty() {
        return this.noOfBytesPerRow;
    }

    public BinaryDataViewController() {
        this.noOfBytesPerRow = new SimpleIntegerProperty();
        this.noOfBytesPerRow.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.refreshData();
            }
        });
        this.bufferItem.addListener((observable, oldValue, newValue) -> this.refreshData());
    }

    @Override
    public void dispose() {
        this.bufferItem.set(null);
    }

    public @NonNull SimpleObjectProperty<IBufferItem> bufferItemProperty() {
        return this.bufferItem;
    }

    private void refreshData() {
        IBufferItem bufferAsset = (IBufferItem)this.bufferItem.get();
        ArrayList<BinaryDataViewItem> itemsToAdd = new ArrayList<BinaryDataViewItem>();
        if (bufferAsset != null && bufferAsset.getDataForBuffer() != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bufferAsset.getDataForBuffer());){
                    int bytesRead = 0;
                    long address = 0L;
                    int n = this.noOfBytesPerRow.getValue();
                    if (n != 0) {
                        byte[] data = new byte[n];
                        bytesRead = ((InputStream)inputStream).read(data, 0, n);
                        while (bytesRead > 0) {
                            assert (data.length == n);
                            if (bytesRead < n) {
                                itemsToAdd.add(new BinaryDataViewItem(address, NullUtils.neverNull((byte[])Arrays.copyOfRange(data, 0, bytesRead))));
                            } else {
                                itemsToAdd.add(new BinaryDataViewItem(address, data));
                            }
                            address += (long)this.noOfBytesPerRow.getValue().intValue();
                            bytesRead = ((InputStream)inputStream).read(data, 0, n);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                CoreLogging.warning(null, (String)"Cannot read buffer data in the buffers view");
            }
        }
        Platform.runLater(() -> this.clearAndSetItems(itemsToAdd));
    }
}

