/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.ui.controllers.commands.ICommand;
import com.arm.mgd.ui.views.BinaryDataViewController;
import com.arm.mgd.ui.views.BinaryDataViewItem;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;

public class BinaryDataView
extends TableView<BinaryDataViewItem> {
    private static final int NO_OF_BYTES_PER_ROW = 16;
    private final IntegerProperty noOfBytesPerRow = new SimpleIntegerProperty(16);

    public BinaryDataView() {
        this.noOfBytesPerRow.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.refreshView();
            }
        });
        this.getStyleClass().add((Object)"binary-data-view");
    }

    public void setupView() {
        this.refreshView();
    }

    public void loadContextMenu(@NonNull BinaryDataViewController controller) {
        HashMap<@NonNull ICommand<T>, @NonNull MenuItem> allMenuItems = new HashMap();
        ContextMenu contextMenu = new ContextMenu();
        allMenuItems.put(controller.getCopyCommand(), ContextMenuHelper.addItem(contextMenu, new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), controller, controller.getCopyCommand()));
        contextMenu.showingProperty().addListener(listener -> allMenuItems.forEach((command, menuItem) -> menuItem.setDisable(!controller.canDispatchCommand(command))));
        ContextMenuHelper.setContextMenu((Node)this, contextMenu);
    }

    public void refreshView() {
        TableColumn addressColumn = new TableColumn("Address");
        addressColumn.setCellValueFactory((Callback)new PropertyValueFactory("address"));
        addressColumn.setCellFactory(column -> {
            TableCell<BinaryDataViewItem, Long> cell = new TableCell<BinaryDataViewItem, Long>(){

                protected void updateItem(Long item, boolean empty) {
                    super.updateItem((Object)item, empty);
                    if (item != null && !empty) {
                        this.setText(String.format("0x%08X", item));
                    } else {
                        this.setText(null);
                    }
                }
            };
            return cell;
        });
        addressColumn.setMinWidth(Double.NEGATIVE_INFINITY);
        addressColumn.setPrefWidth(100.0);
        addressColumn.setSortable(false);
        addressColumn.setResizable(false);
        this.getColumns().add((Object)addressColumn);
        ArrayList<TableColumn> byteColumnList = new ArrayList<TableColumn>();
        int i = 0;
        while (i < this.noOfBytesPerRow.getValue()) {
            final int byteNum = i;
            TableColumn column2 = new TableColumn(String.format("%X", i));
            column2.setCellValueFactory((Callback)new PropertyValueFactory("data"));
            column2.setCellFactory(c -> {
                TableCell<BinaryDataViewItem, List<Byte>> cell = new TableCell<BinaryDataViewItem, List<Byte>>(){

                    protected void updateItem(List<Byte> item, boolean empty) {
                        super.updateItem(item, empty);
                        if (item != null && byteNum < item.size() && item.get(byteNum) != null && !empty) {
                            this.setText(String.format("%02X", item.get(byteNum)));
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            });
            column2.setMinWidth(Double.NEGATIVE_INFINITY);
            column2.setPrefWidth(30.0);
            column2.setSortable(false);
            column2.setResizable(false);
            byteColumnList.add(column2);
            ++i;
        }
        Platform.runLater(() -> {
            this.getColumns().clear();
            this.getColumns().add((Object)addressColumn);
            this.getColumns().addAll((Collection)byteColumnList);
        });
    }

    public IntegerProperty noOfBytesPerRowProperty() {
        return this.noOfBytesPerRow;
    }

    public final void setNoOfBytesPerRow(int value) {
        this.noOfBytesPerRow.set(value);
    }

    public final int getNoOfBytesPerRow() {
        return this.noOfBytesPerRow.get();
    }
}

