/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.controllers.AutomatedTraceViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.dialogs.AutomatedTraceDialog;
import java.io.IOException;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.Nullable;

public class AutomatedTraceView
extends FXViewPart {
    @FXML
    private TableColumn<AutomatedTraceCommand, String> commandTypeColumn;
    @FXML
    private TableColumn<AutomatedTraceCommand, Number> frameNumberColumn;
    @FXML
    private TableView<AutomatedTraceCommand> advancedTraceTable;
    @FXML
    private Button addCommandButton;
    @FXML
    private Button deleteCommandButton;
    @FXML
    private StackPane rootContainer;
    @FXML
    private VBox mainParent;
    @FXML
    private Parent disabledParent;
    @FXML
    private Label disabledReason;
    private AutomatedTraceViewController controller = new AutomatedTraceViewController(this.visibleProperty());
    private Scene scene;

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/automatedTraceView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (StackPane)fxmlLoader.load();
        }
        catch (IOException e2) {
            CoreLogging.severe((Throwable)e2);
        }
        this.scene = new Scene((Parent)this.rootContainer);
        this.advancedTraceTable.setItems(this.controller.getCommands());
        this.advancedTraceTable.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<AutomatedTraceCommand>(){

            public void onChanged(ListChangeListener.Change<? extends AutomatedTraceCommand> change) {
                while (change.next()) {
                    AutomatedTraceView.this.controller.setSelectedItems((ObservableList<? extends AutomatedTraceCommand>)change.getList());
                }
            }
        });
        this.mainParent.visibleProperty().bind((ObservableValue)this.controller.authorised());
        this.disabledParent.visibleProperty().bind((ObservableValue)this.controller.authorised().not());
        this.disabledReason.textProperty().bind((ObservableValue)this.controller.getAuthorisationUserMessage());
        this.setCellFactories();
        this.addCommandButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AutomatedTraceDialog dialog = new AutomatedTraceDialog();
                AutomatedTraceView.this.controller.addCommandButtonPressed(dialog.showAndWaitForResult());
            }
        });
        this.addCommandButton.disableProperty().bind((ObservableValue)this.controller.areAutomatedTraceCommandsAvailableProperty().not());
        this.deleteCommandButton.addEventFilter(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AutomatedTraceView.this.controller.deleteCommandButtonPressed();
            }
        });
        this.deleteCommandButton.disableProperty().bind((ObservableValue)this.controller.areAutomatedTraceCommandsAvailableProperty().not());
        this.advancedTraceTable.addEventFilter(KeyEvent.KEY_PRESSED, e -> this.tryRemoveButtonFire((KeyEvent)e));
        this.advancedTraceTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.controller.getCommands().comparatorProperty().bind((ObservableValue)this.advancedTraceTable.comparatorProperty());
        this.advancedTraceTable.getSortOrder().add(this.frameNumberColumn);
        return this.scene;
    }

    private void tryRemoveButtonFire(KeyEvent e) {
        if (e.getCode() == KeyCode.DELETE) {
            this.controller.deleteCommandButtonPressed();
        }
    }

    private void setCellFactories() {
        this.commandTypeColumn.setCellValueFactory(p -> new SimpleStringProperty(((AutomatedTraceCommand)p.getValue()).getCommandType().getDescription()));
        this.frameNumberColumn.setCellValueFactory(p -> new SimpleIntegerProperty(((AutomatedTraceCommand)p.getValue()).getFrameNumber()));
    }

    @Override
    protected void setFxFocus() {
        this.advancedTraceTable.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.automatedtraceview";
    }

    @Override
    public void dispose() {
        this.controller.close();
        super.dispose();
    }
}

