/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.views;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.ICreatableAndModifiable;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.ui.controllers.AssetsViewController;
import com.arm.mgd.ui.controls.FXViewPart;
import com.arm.mgd.ui.utils.JavaFXImageLoader;
import com.arm.mgd.ui.utils.RGBAImage;
import com.arm.mgd.ui.views.BinaryDataView;
import com.arm.mgd.ui.views.BinaryDataViewController;
import com.arm.mgd.ui.views.widgets.ContextMenuHelper;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AssetsView
extends FXViewPart {
    @FXML
    private VBox rootContainer;
    @FXML
    private TreeTableView<AssetsViewController.PropertyTableItem> treeTable;
    @FXML
    private TreeTableColumn<AssetsViewController.PropertyTableItem, String> nameColumn;
    @FXML
    private TreeTableColumn<AssetsViewController.PropertyTableItem, String> valueColumn;
    @FXML
    private TextArea sourceTextArea;
    @FXML
    private TabPane tabPane;
    @FXML
    private Tab sourceTab;
    @FXML
    private Tab bufferTab;
    @FXML
    private Tab imageTab;
    @FXML
    private BorderPane imageViewPane;
    @FXML
    private ScrollPane imageViewScrollPane;
    @FXML
    private ImageView imageView;
    @FXML
    private TextArea imageLoadErrorTextArea;
    @FXML
    private ProgressIndicator imageSpinner;
    @FXML
    private CheckBox actualSize;
    @FXML
    private ComboBox<RGBAImage.AlphaMode> alphaModeComboBox;
    private final @NonNull AssetsViewController controller = new AssetsViewController(this.visibleProperty());
    private final @NonNull BinaryDataView bufferData = new BinaryDataView();
    private final @NonNull BinaryDataViewController bufferDataController = new BinaryDataViewController();
    private final @NonNull SimpleObjectProperty<@Nullable ImageLoader> currentImageLoader = new SimpleObjectProperty();
    private final @NonNull SimpleBooleanProperty isSelectedAssetCreatableAndModifiable = new SimpleBooleanProperty(false);
    private final @NonNull SimpleBooleanProperty isSelectedAssetCreatedByDummy = new SimpleBooleanProperty(false);
    private final @NonNull SimpleBooleanProperty isSelectedAssetPreviousModifierNull = new SimpleBooleanProperty(false);
    private final @NonNull ExecutorService executor = NamedExecutors.cachedFiniteThreadPool((int)1, (long)60L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("AssetsView Executor", 1));
    private static final PseudoClass WAS_CREATED_IN_THIS_FUNCTION_CLASS = PseudoClass.getPseudoClass((String)"was-created-in-this-function");
    private static final PseudoClass WAS_MODIFIED_IN_THIS_FUNCTION_CLASS = PseudoClass.getPseudoClass((String)"was-modified-in-this-function");
    private static final PseudoClass WAS_ACTIVE_IN_THIS_FUNCTION_CLASS = PseudoClass.getPseudoClass((String)"was-active-in-this-function");

    @Override
    public void dispose() {
        this.controller.dispose();
        this.executor.shutdown();
        super.dispose();
    }

    private void onChangedRootProperty(@Nullable AssetsViewController.AssetsViewRoot oldValue, @Nullable AssetsViewController.AssetsViewRoot newValue) {
        TreeItem<AssetsViewController.PropertyTableItem> newSelectedItem = null;
        if (newValue != null && oldValue != null) {
            newSelectedItem = AssetsView.mirrorTreeItemExpansionState(newValue.root, oldValue.root, (TreeItem<AssetsViewController.PropertyTableItem>)((TreeItem)this.treeTable.getSelectionModel().getSelectedItem()));
        }
        this.treeTable.rootProperty().set(newValue != null ? newValue.root : null);
        this.treeTable.getSelectionModel().select(newSelectedItem);
    }

    private void setImageViewScaling(boolean actualSize) {
        if (actualSize) {
            this.imageView.fitHeightProperty().unbind();
            this.imageView.fitWidthProperty().unbind();
            this.imageView.setFitWidth(0.0);
            this.imageView.setFitHeight(0.0);
        } else {
            this.imageView.fitWidthProperty().bind((ObservableValue)this.imageViewScrollPane.widthProperty().subtract(this.imageViewScrollPane.getInsets().getLeft()).subtract(this.imageViewScrollPane.getInsets().getRight()));
            this.imageView.fitHeightProperty().bind((ObservableValue)this.imageViewScrollPane.heightProperty().subtract(this.imageViewScrollPane.getInsets().getTop()).subtract(this.imageViewScrollPane.getInsets().getBottom()));
        }
    }

    @Override
    protected Scene createFxScene() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/resources/assetsView.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            this.rootContainer = (VBox)fxmlLoader.load();
        }
        catch (IOException e) {
            CoreLogging.severe((Throwable)e);
            return null;
        }
        this.onChangedRootProperty(null, (AssetsViewController.AssetsViewRoot)this.controller.rootProperty().get());
        this.controller.rootProperty().addListener((observable, oldValue, newValue) -> Platform.runLater(() -> this.onChangedRootProperty((AssetsViewController.AssetsViewRoot)oldValue, (AssetsViewController.AssetsViewRoot)newValue)));
        this.nameColumn.setCellValueFactory(cellData -> new SimpleStringProperty(((AssetsViewController.PropertyTableItem)cellData.getValue().getValue()).getName()));
        this.valueColumn.setCellValueFactory(cellData -> new SimpleStringProperty(((AssetsViewController.PropertyTableItem)cellData.getValue().getValue()).getValue()));
        this.nameColumn.setCellFactory(param -> new TreeTableCell<AssetsViewController.PropertyTableItem, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                StringBuilder tooltip = null;
                Image graphic = null;
                AssetsViewController.PropertyTableItem property = null;
                if (!empty && item != null) {
                    tooltip = new StringBuilder().append(item);
                    property = (AssetsViewController.PropertyTableItem)AssetsView.this.treeTable.getTreeItem(this.getIndex()).getValue();
                    if (!$assertionsDisabled && property == null) {
                        throw new AssertionError();
                    }
                    if (property.wasCreatedInThisFunctionCall()) {
                        tooltip.append(System.lineSeparator()).append("This asset was created by the selected function call");
                    } else if (property.wasModifiedInThisFunctionCall()) {
                        tooltip.append(System.lineSeparator()).append("This asset was modified by the selected function call");
                    }
                    if (property.wasActiveInThisFunctionCall()) {
                        tooltip.append(System.lineSeparator()).append("This asset was active in the selected function call");
                    }
                    graphic = property.getGraphic();
                }
                this.setText(item);
                this.setTooltip(tooltip != null ? new Tooltip(tooltip.toString()) : null);
                this.setGraphic((Node)(graphic != null ? new ImageView(graphic) : null));
                AssetsView.setCellPseudoClasses(this, property);
            }
        });
        this.valueColumn.setCellFactory(param -> new TreeTableCell<AssetsViewController.PropertyTableItem, String>(){

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                this.setText(item);
                this.setTooltip(item == null || item.isEmpty() ? null : new Tooltip(item));
                AssetsViewController.PropertyTableItem property = null;
                if (!empty && item != null) {
                    property = (AssetsViewController.PropertyTableItem)AssetsView.this.treeTable.getTreeItem(this.getIndex()).getValue();
                }
                AssetsView.setCellPseudoClasses(this, property);
            }
        });
        this.bufferDataController.noOfBytesPerRowProperty().bind((ObservableValue)this.bufferData.noOfBytesPerRowProperty());
        this.bufferDataController.bindComparatorProperty(this.bufferData.comparatorProperty());
        this.bufferDataController.bindSelectedIndices((ObservableList<Integer>)this.bufferData.getSelectionModel().getSelectedIndices());
        this.bufferData.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.bufferData.setupView();
        this.bufferData.setItems(this.bufferDataController.getItemList());
        this.bufferData.loadContextMenu(this.bufferDataController);
        this.bufferTab.setContent((Node)this.bufferData);
        this.alphaModeComboBox.getItems().setAll((Object[])RGBAImage.AlphaMode.values());
        this.alphaModeComboBox.getSelectionModel().select((Object)RGBAImage.AlphaMode.USE_ALPHA);
        this.actualSize.selectedProperty().addListener((observable, oldValue, newValue) -> this.setImageViewScaling((boolean)newValue));
        this.setImageViewScaling(this.actualSize.isSelected());
        this.currentImageLoader.addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.isCancelled.set(true);
            }
            this.updateImage();
        });
        this.alphaModeComboBox.valueProperty().addListener((observable, oldValue, newValue) -> this.updateImage());
        this.sourceTab.disableProperty().bind((ObservableValue)this.sourceTextArea.textProperty().isEmpty());
        this.sourceTab.getContent().visibleProperty().bind((ObservableValue)this.sourceTab.disabledProperty().not());
        this.bufferTab.disableProperty().bind((ObservableValue)this.bufferDataController.bufferItemProperty().isNull());
        this.bufferTab.getContent().visibleProperty().bind((ObservableValue)this.bufferTab.disabledProperty().not());
        this.imageTab.disableProperty().bind((ObservableValue)this.currentImageLoader.isNull());
        this.imageTab.getContent().visibleProperty().bind((ObservableValue)this.imageTab.disabledProperty().not());
        this.imageViewPane.visibleProperty().bind((ObservableValue)this.imageView.imageProperty().isNotNull());
        BooleanBinding imageLoadError = this.imageLoadErrorTextArea.textProperty().isNotEmpty();
        this.imageSpinner.visibleProperty().bind((ObservableValue)this.imageView.imageProperty().isNull().and((ObservableBooleanValue)imageLoadError.not()));
        this.imageLoadErrorTextArea.visibleProperty().bind((ObservableValue)imageLoadError);
        this.treeTable.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            AssetsViewController.PropertyTableItem tableItem;
            boolean isNewSelectionCreatableAndModifiable = false;
            boolean isNewSelectionCreatedByDummy = false;
            boolean isNewSelectionPreviousModifierNull = false;
            String source = null;
            IImageProvider imageProvider = null;
            IBufferItem buffer = null;
            if (newValue != null && (tableItem = (AssetsViewController.PropertyTableItem)newValue.getValue()) != null) {
                IAssetProperty asset = tableItem.getAssetProperty();
                if (asset != null) {
                    buffer = asset.getBufferForm();
                    source = asset.getTextForm();
                    imageProvider = asset.getImageForm();
                }
                if (asset instanceof ICreatableAndModifiable) {
                    isNewSelectionCreatableAndModifiable = true;
                    @NonNull ICreatableAndModifiable creatable = (ICreatableAndModifiable)asset;
                    isNewSelectionCreatedByDummy = creatable.getCreatedByFunction() instanceof TraceDataModel.DummyFunctionCall;
                    FunctionCall previous = creatable.getPreviousModificationFunction();
                    assert (!(previous instanceof TraceDataModel.DummyFunctionCall));
                    isNewSelectionPreviousModifierNull = previous == null;
                }
            }
            this.isSelectedAssetCreatedByDummy.set(isNewSelectionCreatedByDummy);
            this.isSelectedAssetPreviousModifierNull.set(isNewSelectionPreviousModifierNull);
            this.isSelectedAssetCreatableAndModifiable.set(isNewSelectionCreatableAndModifiable);
            this.sourceTextArea.textProperty().set((Object)source);
            this.bufferDataController.bufferItemProperty().set((Object)buffer);
            this.currentImageLoader.set((Object)(imageProvider != null ? new ImageLoader(imageProvider) : null));
            if (((Tab)this.tabPane.getSelectionModel().getSelectedItem()).isDisabled()) {
                for (Tab t : this.tabPane.getTabs()) {
                    if (t.isDisabled()) continue;
                    this.tabPane.getSelectionModel().select((Object)t);
                    break;
                }
            }
        });
        this.loadContextMenu();
        ContextMenuHelper.createAndSetContextMenuForTextInputField((TextInputControl)NullUtils.neverNull((Object)this.sourceTextArea), true);
        return new Scene((Parent)this.rootContainer);
    }

    private void updateImage() {
        assert (Platform.isFxApplicationThread());
        this.imageView.setImage(null);
        this.imageLoadErrorTextArea.textProperty().set(null);
        ImageLoader loader = (ImageLoader)this.currentImageLoader.get();
        RGBAImage.AlphaMode alphaMode = (RGBAImage.AlphaMode)((Object)this.alphaModeComboBox.valueProperty().get());
        if (loader != null && alphaMode != null) {
            this.executor.execute(() -> {
                if (imageLoader.isCancelled.get()) {
                    return;
                }
                Image image = null;
                boolean isFlipped = false;
                String loadError = null;
                try {
                    JavaFXImageLoader.JavaFXImage javaFXImage = loader.getImage(alphaMode);
                    image = javaFXImage.image;
                    isFlipped = javaFXImage.rawImage.isFlipped();
                }
                catch (Throwable t) {
                    loadError = t.getMessage();
                }
                Image finalImage = image;
                boolean finalIsFlipped = isFlipped;
                String finalLoadError = loadError;
                Platform.runLater(() -> {
                    RGBAImage.AlphaMode newAlpha = (RGBAImage.AlphaMode)((Object)((Object)((Object)this.alphaModeComboBox.valueProperty().get())));
                    if (!imageLoader.isCancelled.get() && newAlpha == alphaMode) {
                        this.imageView.setImage(finalImage);
                        this.imageView.setScaleY((double)(finalIsFlipped ? -1 : 1));
                        this.imageLoadErrorTextArea.textProperty().set((Object)finalLoadError);
                    }
                });
            });
        }
    }

    private void loadContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem showCreatedByFunc = new MenuItem("Show Creating Function");
        showCreatedByFunc.setOnAction(event -> {
            @Nullable IAssetProperty asset = ((AssetsViewController.PropertyTableItem)((TreeItem)this.treeTable.getSelectionModel().getSelectedItem()).getValue()).getAssetProperty();
            if (asset instanceof ICreatableAndModifiable) {
                FunctionCall createdByFunction = ((ICreatableAndModifiable)asset).getCreatedByFunction();
                CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)createdByFunction), (Object)this);
            }
        });
        showCreatedByFunc.disableProperty().bind((ObservableValue)this.isSelectedAssetCreatableAndModifiable.not().or((ObservableBooleanValue)this.isSelectedAssetCreatedByDummy));
        MenuItem showPreviousModifiedFunc = new MenuItem("Show Previous Affecting Function");
        showPreviousModifiedFunc.setOnAction(event -> {
            @Nullable IAssetProperty asset = ((AssetsViewController.PropertyTableItem)((TreeItem)this.treeTable.getSelectionModel().getSelectedItem()).getValue()).getAssetProperty();
            if (asset instanceof ICreatableAndModifiable) {
                FunctionCall previousModificationFunction = ((ICreatableAndModifiable)asset).getPreviousModificationFunction();
                if (previousModificationFunction == null) {
                    previousModificationFunction = ((ICreatableAndModifiable)asset).getCreatedByFunction();
                }
                CoreInstance.getNavigationManager().setNavigationURI(new NavigationUri((INavigationElement)previousModificationFunction), (Object)this);
            }
        });
        showPreviousModifiedFunc.disableProperty().bind((ObservableValue)this.isSelectedAssetCreatableAndModifiable.not().or((ObservableBooleanValue)this.isSelectedAssetPreviousModifierNull));
        MenuItem copy = new MenuItem("Copy");
        copy.setOnAction(event -> {
            @Nullable AssetsViewController.PropertyTableItem tableItem = (AssetsViewController.PropertyTableItem)((TreeItem)this.treeTable.getSelectionModel().getSelectedItem()).getValue();
            if (tableItem != null) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(tableItem.getName());
                if (!tableItem.getValue().isEmpty()) {
                    stringBuilder.append("\t").append(tableItem.getValue());
                }
                content.putString(stringBuilder.toString());
                clipboard.setContent((Map)content);
            }
        });
        copy.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}));
        copy.disableProperty().bind((ObservableValue)this.treeTable.getSelectionModel().selectedItemProperty().isNull());
        contextMenu.getItems().addAll((Object[])new MenuItem[]{showCreatedByFunc, showPreviousModifiedFunc, copy});
        ContextMenuHelper.setContextMenu((Node)NullUtils.neverNull(this.treeTable), contextMenu);
    }

    private static void setCellPseudoClasses(@NonNull TreeTableCell<AssetsViewController.PropertyTableItem, String> cell, @Nullable AssetsViewController.PropertyTableItem property) {
        boolean created = false;
        boolean modified = false;
        boolean active = false;
        if (property != null) {
            created = property.wasCreatedInThisFunctionCall();
            modified = property.wasModifiedInThisFunctionCall();
            active = property.wasActiveInThisFunctionCall();
        }
        cell.pseudoClassStateChanged(WAS_CREATED_IN_THIS_FUNCTION_CLASS, created);
        cell.pseudoClassStateChanged(WAS_MODIFIED_IN_THIS_FUNCTION_CLASS, modified);
        cell.pseudoClassStateChanged(WAS_ACTIVE_IN_THIS_FUNCTION_CLASS, active);
    }

    private static @Nullable TreeItem<AssetsViewController.PropertyTableItem> mirrorTreeItemExpansionState(@NonNull TreeItem<AssetsViewController.PropertyTableItem> newTreeItem, @NonNull TreeItem<AssetsViewController.PropertyTableItem> oldTreeItem, @Nullable TreeItem<AssetsViewController.PropertyTableItem> selectedItem) {
        ObservableList newChildren = newTreeItem.getChildren();
        ObservableList oldChildren = oldTreeItem.getChildren();
        TreeItem outNewSelectedItem = null;
        if (newChildren == null || oldChildren == null) {
            return outNewSelectedItem;
        }
        block0: for (TreeItem oldChild : oldChildren) {
            if (oldChild instanceof AssetsViewController.IRepresentsSamePropertyTableItem) {
                if (oldChild.expandedProperty().get()) {
                    for (TreeItem newChild : newChildren) {
                        if (!((AssetsViewController.IRepresentsSamePropertyTableItem)oldChild).representsSamePropertyTableItem(newChild)) continue;
                        newChild.setExpanded(true);
                        TreeItem newSelectedItem = AssetsView.mirrorTreeItemExpansionState((TreeItem<AssetsViewController.PropertyTableItem>)newChild, (TreeItem<AssetsViewController.PropertyTableItem>)oldChild, selectedItem);
                        if (newSelectedItem == null) continue;
                        outNewSelectedItem = newSelectedItem;
                    }
                }
                if (outNewSelectedItem != null || oldChild != selectedItem) continue;
                for (TreeItem newChild : newChildren) {
                    if (!((AssetsViewController.IRepresentsSamePropertyTableItem)oldChild).representsSamePropertyTableItem(newChild)) continue;
                    outNewSelectedItem = newChild;
                    continue block0;
                }
                continue;
            }
            assert (false) : "All tree items in the assets view must implement IRepresentsSamePropertyTableItem";
        }
        return outNewSelectedItem;
    }

    @Override
    protected void setFxFocus() {
        this.rootContainer.requestFocus();
    }

    @Override
    protected @Nullable String getHelpId() {
        return "com.arm.mgd.help.assetsview";
    }

    private static class ImageLoader
    extends JavaFXImageLoader {
        private final @NonNull AtomicBoolean isCancelled = new AtomicBoolean();

        private ImageLoader(@NonNull IImageProvider imageProvider) {
            super(imageProvider);
        }
    }
}

