/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.NavigationManager;
import com.arm.mgd.core.navigation.TogglableNavigationChangedListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import org.eclipse.jdt.annotation.NonNull;

public class TogglableFXNavigationChangedListener {
    private final @NonNull NavigationManager navigationManager;
    private final @NonNull BooleanProperty enabledProperty;
    private final @NonNull TogglableNavigationChangedListener togglableListener;

    public TogglableFXNavigationChangedListener(@NonNull NavigationManager navigationManager, @NonNull ReadOnlyBooleanProperty enabledProperty, @NonNull INavigationChangedListener listener) {
        this.navigationManager = navigationManager;
        this.enabledProperty = new SimpleBooleanProperty(!enabledProperty.get());
        this.togglableListener = navigationManager.createAndAddTogglableNavigationChangedListener(listener);
        this.enabledProperty.addListener((observable, oldValue, newValue) -> this.togglableListener.setEnabled(newValue.booleanValue()));
        this.enabledProperty.bind((ObservableValue)enabledProperty);
    }

    public void dispose() {
        this.enabledProperty.unbind();
        this.navigationManager.removeTogglableNavigationChangedListener(this.togglableListener);
    }
}

