/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.asset.texture.RGBAImageData;
import java.nio.ByteBuffer;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.eclipse.jdt.annotation.NonNull;

public class RGBAImage {
    private final @NonNull RGBAImageData rgbaImageData;

    public RGBAImage(@NonNull RGBAImageData rgbaImageData) {
        this.rgbaImageData = rgbaImageData;
    }

    public @NonNull Image getImage(@NonNull AlphaMode alphaMode) {
        assert (!Platform.isFxApplicationThread());
        switch (alphaMode) {
            case IGNORE_ALPHA: {
                return this.createImageWithAlphaSetToMax();
            }
            case USE_ALPHA: {
                return this.createImageWithOriginalAlpha();
            }
            case VISUALIZE_GREYSCALE_ALPHA: {
                return this.createImageWithGreyScaleAlpha();
            }
        }
        throw new AssertionError((Object)alphaMode);
    }

    public @NonNull RGBAImageData getRGBAImageData() {
        return this.rgbaImageData;
    }

    public int getWidth() {
        return this.rgbaImageData.getSize().getWidth();
    }

    public int getHeight() {
        return this.rgbaImageData.getSize().getHeight();
    }

    public boolean isFlipped() {
        return this.rgbaImageData.getCoordinateOrigin() != RGBAImageData.CoordinateOrigin.TOP_LEFT;
    }

    private @NonNull Image createImageWithAlphaSetToMax() {
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer srcRGBA = this.rgbaImageData.getData().getData();
        byte[] dstBGRA = new byte[width * height * 4];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int sourceOffset = (height - 1 - y) * width * 4 + x * 4;
                int destinationOffset = y * width * 4 + x * 4;
                dstBGRA[destinationOffset] = srcRGBA.get(sourceOffset + 2);
                dstBGRA[destinationOffset + 1] = srcRGBA.get(sourceOffset + 1);
                dstBGRA[destinationOffset + 2] = srcRGBA.get(sourceOffset);
                dstBGRA[destinationOffset + 3] = -1;
                ++x;
            }
            ++y;
        }
        WritableImage writableImage = new WritableImage(width, height);
        PixelWriter pw = writableImage.getPixelWriter();
        pw.setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getByteBgraInstance(), dstBGRA, 0, width * 4);
        return writableImage;
    }

    private @NonNull Image createImageWithOriginalAlpha() {
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer srcRGBA = this.rgbaImageData.getData().getData();
        byte[] dstBGRA = new byte[width * height * 4];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int sourceOffset = (height - 1 - y) * width * 4 + x * 4;
                int destinationOffset = y * width * 4 + x * 4;
                dstBGRA[destinationOffset] = srcRGBA.get(sourceOffset + 2);
                dstBGRA[destinationOffset + 1] = srcRGBA.get(sourceOffset + 1);
                dstBGRA[destinationOffset + 2] = srcRGBA.get(sourceOffset);
                dstBGRA[destinationOffset + 3] = srcRGBA.get(sourceOffset + 3);
                ++x;
            }
            ++y;
        }
        WritableImage writableImage = new WritableImage(width, height);
        PixelWriter pw = writableImage.getPixelWriter();
        pw.setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getByteBgraInstance(), dstBGRA, 0, width * 4);
        return writableImage;
    }

    private @NonNull Image createImageWithGreyScaleAlpha() {
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer srcRGBA = this.rgbaImageData.getData().getData();
        byte[] dstBGRA = new byte[width * height * 4];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                byte alpha;
                int sourceOffset = (height - 1 - y) * width * 4 + x * 4;
                int destinationOffset = y * width * 4 + x * 4;
                dstBGRA[destinationOffset] = alpha = srcRGBA.get(sourceOffset + 3);
                dstBGRA[destinationOffset + 1] = alpha;
                dstBGRA[destinationOffset + 2] = alpha;
                dstBGRA[destinationOffset + 3] = -1;
                ++x;
            }
            ++y;
        }
        WritableImage writableImage = new WritableImage(width, height);
        PixelWriter pw = writableImage.getPixelWriter();
        pw.setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getByteBgraInstance(), dstBGRA, 0, width * 4);
        return writableImage;
    }

    public static enum AlphaMode {
        IGNORE_ALPHA("Ignore Alpha"),
        USE_ALPHA("Use Alpha"),
        VISUALIZE_GREYSCALE_ALPHA("Visualize Alpha Channel");

        private final @NonNull String description;

        private AlphaMode(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

