/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public class ObservableSortedSet<T>
implements ObservableSet<T>,
SortedSet<T> {
    private final ObservableSet<T> observableSet;
    private final SortedSet<T> sortedSet;

    public ObservableSortedSet() {
        this(new TreeSet());
    }

    public ObservableSortedSet(SortedSet<T> wrap) {
        if (wrap == null) {
            throw new NullPointerException();
        }
        this.observableSet = FXCollections.observableSet(wrap);
        this.sortedSet = wrap;
    }

    @Override
    public boolean add(T e) {
        return this.observableSet.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.observableSet.addAll(c);
    }

    public void addListener(InvalidationListener listener) {
        this.observableSet.addListener(listener);
    }

    public void addListener(SetChangeListener<? super T> listener) {
        this.observableSet.addListener(listener);
    }

    @Override
    public void clear() {
        this.observableSet.clear();
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.sortedSet.comparator();
    }

    @Override
    public boolean contains(Object o) {
        return this.observableSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.observableSet.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Set) {
            return ((Set)obj).equals(this.sortedSet);
        }
        return false;
    }

    @Override
    public T first() {
        return this.sortedSet.first();
    }

    @Override
    public int hashCode() {
        return this.sortedSet.hashCode();
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        return new ObservableSortedSet<T>(this.sortedSet.headSet(toElement));
    }

    @Override
    public boolean isEmpty() {
        return this.observableSet.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.observableSet.iterator();
    }

    @Override
    public T last() {
        return this.sortedSet.last();
    }

    @Override
    public boolean remove(Object o) {
        return this.observableSet.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.observableSet.removeAll(c);
    }

    public void removeListener(InvalidationListener listener) {
        this.observableSet.removeListener(listener);
    }

    public void removeListener(SetChangeListener<? super T> listener) {
        this.observableSet.removeListener(listener);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.observableSet.retainAll(c);
    }

    @Override
    public int size() {
        return this.observableSet.size();
    }

    @Override
    public ObservableSortedSet<T> subSet(T fromElement, T toElement) {
        return new ObservableSortedSet<T>(this.sortedSet.subSet(fromElement, toElement));
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        return new ObservableSortedSet<T>(this.sortedSet.tailSet(fromElement));
    }

    @Override
    public Object[] toArray() {
        return this.observableSet.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.observableSet.toArray((Object[])a);
    }

    public String toString() {
        return this.sortedSet.toString();
    }
}

