/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ObjectChangeWrapper<T> {
    private @Nullable T currentValue = null;
    private final @NonNull RebindInterface<T> rebindInterface;

    public ObjectChangeWrapper(@NonNull RebindInterface<T> rebindInterface) {
        this.rebindInterface = rebindInterface;
    }

    public synchronized @Nullable T get() {
        return this.currentValue;
    }

    public synchronized boolean isCurrent(@NonNull T object) {
        return NullUtils.equals(this.currentValue, object);
    }

    public synchronized @Nullable T set(@Nullable T newValue) {
        @Nullable T oldValue = this.currentValue;
        if (oldValue != null) {
            this.rebindInterface.removeOldListeners(oldValue);
        }
        if (newValue != null) {
            this.rebindInterface.addNewListeners(newValue);
        }
        this.currentValue = newValue;
        return oldValue;
    }

    public static interface RebindInterface<T> {
        public void addNewListeners(@NonNull T var1);

        public void removeOldListeners(@NonNull T var1);
    }
}

