/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.utils.NullUtils;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.scene.control.TextField;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NumericTextField
extends TextField {
    private final @NonNull ReadOnlyIntegerWrapper numericValueWrapper = new ReadOnlyIntegerWrapper();

    public NumericTextField() {
        this.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.equals("")) {
                this.numericValueWrapper.set(0);
                return;
            }
            this.numericValueWrapper.set(Integer.parseInt(newValue));
        });
    }

    public @NonNull ReadOnlyIntegerProperty getNumericValueProperty() {
        return (ReadOnlyIntegerProperty)NullUtils.neverNull((Object)this.numericValueWrapper.getReadOnlyProperty());
    }

    public void replaceText(int start, int end, String text) {
        if (NumericTextField.validateTextIsNumeric(text)) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String replacement) {
        if (NumericTextField.validateTextIsNumeric(replacement)) {
            super.replaceSelection(replacement);
        }
    }

    private static boolean validateTextIsNumeric(@Nullable String text) {
        if (text == null) {
            return false;
        }
        return text.matches("[0-9]*");
    }
}

