/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.util.LazyObjectGenerator;
import com.arm.mgd.core.util.ValueOrThrowable;
import com.arm.mgd.ui.utils.RGBAImage;
import javafx.application.Platform;
import javafx.scene.image.Image;
import org.eclipse.jdt.annotation.NonNull;

public class JavaFXImageLoader {
    private final @NonNull LazyObjectGenerator<ValueOrThrowable<RGBAImage, Throwable>> lazyImageData;

    public JavaFXImageLoader(final @NonNull IImageProvider provider) {
        this.lazyImageData = new LazyObjectGenerator<ValueOrThrowable<RGBAImage, Throwable>>(){

            protected @NonNull ValueOrThrowable<RGBAImage, Throwable> generateObject() {
                try {
                    return new ValueOrThrowable((Object)new RGBAImage(provider.getImageData()));
                }
                catch (Throwable t) {
                    return new ValueOrThrowable(t);
                }
            }
        };
    }

    public @NonNull JavaFXImage getImage(@NonNull RGBAImage.AlphaMode alphaMode) throws Throwable {
        assert (!Platform.isFxApplicationThread());
        RGBAImage rawImage = (RGBAImage)((ValueOrThrowable)this.lazyImageData.get()).get();
        return new JavaFXImage(rawImage, alphaMode);
    }

    public static class JavaFXImage {
        public final @NonNull RGBAImage rawImage;
        public final @NonNull RGBAImage.AlphaMode alphaMode;
        public final @NonNull Image image;

        private JavaFXImage(@NonNull RGBAImage rawImage, @NonNull RGBAImage.AlphaMode alphaMode) {
            this.rawImage = rawImage;
            this.alphaMode = alphaMode;
            this.image = rawImage.getImage(alphaMode);
        }
    }
}

