/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.export.BufferItemAssetExporter;
import com.arm.mgd.core.export.GlFramebufferAssetExporter;
import com.arm.mgd.core.export.GlShaderAssetExporter;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.IAssetsCollectionGetter;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.IGlShaderAssetGetter;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public class GUIExporterController {
    public static @NonNull Job exportCapturedFramebuffers(final @NonNull HashMap<@NonNull TraceDataModel, Set<Integer>> modelToSelectedDrawCallsMap, final @NonNull File directory) {
        assert (directory.isDirectory());
        Job job = new Job("Exporting Framebuffers"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean success = GlFramebufferAssetExporter.export((HashMap)modelToSelectedDrawCallsMap, (File)directory, (ICoreProgressMonitor)new SimpleCoreProgressMonitor(monitor));
                return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    public static @NonNull Job exportSelectedShaders(@NonNull Collection<@NonNull GlShaderAsset> shaderAssets, @NonNull File directory) {
        return GUIExporterController.getExportSelectedShadersJob((IAssetsCollectionGetter<GlShaderAsset>)((IAssetsCollectionGetter)() -> shaderAssets), directory);
    }

    public static @NonNull Job exportAllShadersAtFunction(@NonNull TraceDataModel model, int functionIndex, @NonNull File directory) {
        assert (directory.isDirectory());
        assert (functionIndex < model.count());
        assert (functionIndex > 0);
        return GUIExporterController.getExportSelectedShadersJob((IAssetsCollectionGetter<GlShaderAsset>)IGlShaderAssetGetter.getAllShadersAtFunctionCall((TraceDataModel)model, (int)functionIndex), directory);
    }

    public static @NonNull Job exportSpecificShadersAtFunction(@NonNull TraceDataModel model, @NonNull Set<@NonNull Long> shaderIDs, int functionIndex, @NonNull File directory) {
        assert (directory.isDirectory());
        assert (functionIndex < model.count());
        assert (functionIndex > 0);
        return GUIExporterController.getExportSelectedShadersJob((IAssetsCollectionGetter<GlShaderAsset>)IGlShaderAssetGetter.getSpecificShadersAtFunctionCall((TraceDataModel)model, shaderIDs, (int)functionIndex), directory);
    }

    public static @NonNull Job exportSpecificShadersAtFrame(@NonNull TraceDataModel model, @NonNull Set<@NonNull Long> shaderIDs, int frameIndex, @NonNull File directory) {
        assert (directory.isDirectory());
        assert (frameIndex >= 0);
        return GUIExporterController.getExportSelectedShadersJob((IAssetsCollectionGetter<GlShaderAsset>)IGlShaderAssetGetter.getSpecificShadersAtFrame((TraceDataModel)model, shaderIDs, (int)frameIndex), directory);
    }

    public static @NonNull Job exportAllShadersAtFrame(@NonNull TraceDataModel model, int frameIndex, @NonNull File directory) {
        assert (directory.isDirectory());
        assert (frameIndex >= 0);
        return GUIExporterController.getExportSelectedShadersJob((IAssetsCollectionGetter<GlShaderAsset>)IGlShaderAssetGetter.getAllShadersAtFrame((TraceDataModel)model, (int)frameIndex), directory);
    }

    private static @NonNull Job getExportSelectedShadersJob(final @NonNull IAssetsCollectionGetter<@NonNull GlShaderAsset> getter, final @NonNull File directory) {
        Job job = new Job("Exporting Shaders"){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected IStatus run(IProgressMonitor monitor) {
                @NonNull Collection shaders = getter.get();
                boolean success = GlShaderAssetExporter.export((Collection)shaders, (File)directory, (ICoreProgressMonitor)new SimpleCoreProgressMonitor(monitor));
                return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    public static @NonNull Job exportSelectedBuffers(final @NonNull Collection<@NonNull IBufferItem> buffers, final @NonNull File directory) {
        Job job = new Job("Exporting Buffers"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean success = BufferItemAssetExporter.export((Collection)buffers, (File)directory, (ICoreProgressMonitor)new SimpleCoreProgressMonitor(monitor));
                return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    public static @NonNull Job exportSelectedGeometry(final float[] pointsArray, final int[] facesArray, final File outFile) {
        Job job = new Job("Exporting Geometry"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean wasProblem = false;
                if (!$assertionsDisabled && pointsArray.length % 3 != 0) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && facesArray.length % 6 != 0) {
                    throw new AssertionError();
                }
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (PrintWriter writer = new PrintWriter(outFile);){
                        int pointsIndex = 0;
                        while (pointsIndex < pointsArray.length) {
                            writer.write("v " + pointsArray[pointsIndex + 0] + " " + pointsArray[pointsIndex + 1] + " " + pointsArray[pointsIndex + 2] + "\n");
                            pointsIndex += 3;
                        }
                        writer.write("\n");
                        int facesIndex = 0;
                        while (facesIndex < facesArray.length) {
                            writer.write("f " + (facesArray[facesIndex + 0] + 1) + " " + (facesArray[facesIndex + 2] + 1) + " " + (facesArray[facesIndex + 4] + 1) + "\n");
                            facesIndex += 6;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    CoreLogging.warning(null, (String)("Unable to create " + outFile.getAbsolutePath() + ": " + e.getMessage()));
                    wasProblem = true;
                }
                if (wasProblem) {
                    CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"There were some problems exporting geometry. See the console for more information.");
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }
}

