/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.ui.FXImages;
import java.util.List;
import javafx.scene.image.Image;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FramebufferFeatureIcons {
    private static final @NonNull Descriptor CAPTURE_ALL_ATTACHMENTS = new Descriptor(FXImages.CAPTURE_ALL_ATTACHMENTS, FXImages.CAPTURE_ALL_ATTACHMENTS_REPLAY, FXImages.CAPTURE_ALL_ATTACHMENTS_REPLAY, FXImages.CAPTURE_ALL_ATTACHMENTS, "Capture All Attachments Mode Enabled");
    private static final @NonNull FramebufferFeatureIcons EMPTY_FRAME = new FramebufferFeatureIcons(FXImages.ERROR, "No renderpasses");
    private static final @NonNull FramebufferFeatureIcons FRAME_NOT_COMPLETE = new FramebufferFeatureIcons(FXImages.FRAME_NOT_COMPLETE, "Frame not complete");
    private static final @NonNull Descriptor FRAGMENT_COUNT = new Descriptor(FXImages.FRAGMENT_COUNT, FXImages.FRAGMENT_COUNT_REPLAY, FXImages.FRAGMENT_COUNT_REPLAY, FXImages.FRAGMENT_COUNT, "Fragment Count Mode Enabled");
    private static final @NonNull Descriptor NORMAL_FRAME = new Descriptor(FXImages.FRAME, FXImages.FRAME_REPLAY, FXImages.FRAME_REPLAY_CAPTURE, FXImages.CAPTURED_FRAME, null);
    private static final @NonNull Descriptor OVERDRAW = new Descriptor(FXImages.OVERDRAW, FXImages.OVERDRAW_REPLAY, FXImages.OVERDRAW_REPLAY, FXImages.OVERDRAW, "Overdraw Mode Enabled");
    private static final @NonNull Descriptor SHADER_MAP = new Descriptor(FXImages.SHADER_MAP, FXImages.SHADER_MAP_REPLAY, FXImages.SHADER_MAP_REPLAY, FXImages.SHADER_MAP, "Shadermap Mode Enabled");
    private static final @NonNull Descriptor NORMAL_RENDERPASS = new Descriptor(FXImages.FILM, FXImages.FRAME_REPLAY, FXImages.FRAME_REPLAY_CAPTURE, FXImages.CAPTURED_FRAME, null);
    public final @Nullable String description;
    public final @NonNull Image image;

    public static final @NonNull FramebufferFeatureIcons get(@NonNull FrameRenderPass renderPass) {
        switch (renderPass.getCaptureMode()) {
            case FRAGMENT_COUNT: {
                return FRAGMENT_COUNT.getDecorated(renderPass);
            }
            case OVERDRAW: {
                return OVERDRAW.getDecorated(renderPass);
            }
            case SHADER_MAP: {
                return SHADER_MAP.getDecorated(renderPass);
            }
            case CAPTURE_ALL_ATTACHMENTS: {
                return CAPTURE_ALL_ATTACHMENTS.getDecorated(renderPass);
            }
        }
        return NORMAL_RENDERPASS.getDecorated(renderPass);
    }

    public static final @NonNull FramebufferFeatureIcons get(@NonNull Frame frame) {
        if (!frame.isTheChildrenListFinal()) {
            return FRAME_NOT_COMPLETE;
        }
        if (frame.getRenderPassList().isEmpty()) {
            return EMPTY_FRAME;
        }
        List framebufferFeatures = frame.getFramebufferFeatures();
        FramebufferFeature singleFeature = FramebufferFeatureIcons.getSingleActiveFeature(framebufferFeatures);
        if (singleFeature != null) {
            switch (singleFeature.getCaptureMode()) {
                case FRAGMENT_COUNT: {
                    return FRAGMENT_COUNT.getDecorated(frame);
                }
                case OVERDRAW: {
                    return OVERDRAW.getDecorated(frame);
                }
                case SHADER_MAP: {
                    return SHADER_MAP.getDecorated(frame);
                }
                case CAPTURE_ALL_ATTACHMENTS: {
                    return CAPTURE_ALL_ATTACHMENTS.getDecorated(frame);
                }
            }
            return NORMAL_FRAME.getDecorated(frame);
        }
        return NORMAL_FRAME.getDecorated(frame);
    }

    private static @Nullable FramebufferFeature getSingleActiveFeature(List<FramebufferFeature> frameFeatures) {
        if (frameFeatures.size() == 1) {
            return frameFeatures.get(0);
        }
        return null;
    }

    private FramebufferFeatureIcons(@NonNull Image image, @Nullable String description) {
        this.image = image;
        this.description = description;
    }

    private static class Descriptor {
        public final @NonNull Image captureImage;
        public final @Nullable String description;
        public final @NonNull Image replayCaptureImage;
        public final @NonNull Image replayImage;
        public final @NonNull Image standardImage;

        private Descriptor(@NonNull Image standardImage, @NonNull Image replayImage, @NonNull Image replayCaptureImage, @NonNull Image captureImage, @Nullable String description) {
            this.standardImage = standardImage;
            this.replayImage = replayImage;
            this.replayCaptureImage = replayCaptureImage;
            this.captureImage = captureImage;
            this.description = description;
        }

        public @NonNull FramebufferFeatureIcons getDecorated(@NonNull FrameRenderPass renderPass) {
            if (renderPass.isReplayed()) {
                if (renderPass.isCaptured()) {
                    return this.getDecoratedText(this.replayCaptureImage, "Captured Replay Render Pass");
                }
                return this.getDecoratedText(this.replayImage, "Replay Render Pass");
            }
            if (renderPass.isCaptured()) {
                return this.getDecoratedText(this.captureImage, "Captured Render Pass");
            }
            return new FramebufferFeatureIcons(this.standardImage, this.description);
        }

        public @NonNull FramebufferFeatureIcons getDecorated(@NonNull Frame frame) {
            if (frame.isReplayed()) {
                if (frame.isCaptured()) {
                    return this.getDecoratedText(this.replayCaptureImage, "Captured Replay Frame");
                }
                return this.getDecoratedText(this.replayImage, "Replay Frame");
            }
            if (frame.isCaptured()) {
                return this.getDecoratedText(this.captureImage, "Captured Frame");
            }
            if (frame.hasMidstreamTraceData()) {
                return this.getDecoratedText(FXImages.MIDSTREAM_ATTACHMENT, "Host re-attached to target during this frame");
            }
            return new FramebufferFeatureIcons(this.standardImage, this.description);
        }

        private @NonNull FramebufferFeatureIcons getDecoratedText(@NonNull Image image, @NonNull String decoratorText) {
            if (this.description == null) {
                return new FramebufferFeatureIcons(image, decoratorText);
            }
            return new FramebufferFeatureIcons(image, String.format("%s with %s", decoratorText, this.description));
        }
    }
}

