/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.ui.DialogFileTypes;
import com.arm.mgd.utils.NullUtils;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FileDialogHelper {
    private static final String LAST_SAVE_TRACE_FILE_LOCATION_IDENTIFIER = "lastSaveTraceFileLocation";
    private static final String LAST_SAVE_DIRECTORY_LOCATION_IDENTIFIER = "lastSaveDirectoryLocation";

    public static File promptForFile(DialogFileTypes promptType, Shell shell, boolean forceFileExtension, @Nullable File fileSuggestion) {
        File selectedFile;
        FileDialog dialog = promptType.createDialog(shell);
        String lastSaveTraceFileLocation = PlatformUI.getPreferenceStore().getString(LAST_SAVE_TRACE_FILE_LOCATION_IDENTIFIER);
        if (lastSaveTraceFileLocation != null && !lastSaveTraceFileLocation.isEmpty()) {
            dialog.setFilterPath(lastSaveTraceFileLocation);
        }
        shell.setEnabled(false);
        if (fileSuggestion != null) {
            dialog.setFileName(FileDialogHelper.stripExtension((String)NullUtils.neverNull((Object)fileSuggestion.getName())));
        } else {
            dialog.setFileName(FileDialogHelper.getDefaultTraceFileName());
        }
        String selectedFilePath = dialog.open();
        shell.setEnabled(true);
        if (selectedFilePath == null) {
            return null;
        }
        if (forceFileExtension && dialog.getFilterIndex() != -1) {
            String selectedExtension = dialog.getFilterExtensions()[dialog.getFilterIndex()];
            selectedFilePath = FileDialogHelper.appendFileExtensionIfNotAlreadyThere(selectedFilePath, (String)NullUtils.neverNull((Object)selectedExtension));
        }
        if ((selectedFile = new File(selectedFilePath)).exists()) {
            PlatformUI.getPreferenceStore().setValue(LAST_SAVE_TRACE_FILE_LOCATION_IDENTIFIER, selectedFile.getParent());
            shell.setEnabled(false);
            boolean okToOverwrite = MessageDialog.openConfirm((Shell)shell, (String)"Confirm Overwrite", (String)("File '" + selectedFile.getAbsolutePath() + "' already exists. Continuing will overwrite it."));
            shell.setEnabled(true);
            if (!okToOverwrite) {
                return null;
            }
        }
        return selectedFile;
    }

    private static String stripExtension(@NonNull String stringToStrip) {
        int lastDotPosition = stringToStrip.lastIndexOf(".");
        if (lastDotPosition > 0) {
            return stringToStrip.substring(0, lastDotPosition);
        }
        return stringToStrip;
    }

    private static String appendFileExtensionIfNotAlreadyThere(@NonNull String filePath, @NonNull String fileExtension) {
        if (fileExtension.equals("*.*")) {
            return filePath;
        }
        String extension = fileExtension.substring(1, fileExtension.length());
        if (filePath.endsWith(extension)) {
            return filePath;
        }
        return String.valueOf(filePath) + extension;
    }

    private static String getDefaultTraceFileName() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        return "Trace from " + dateFormat.format(calendar.getTime());
    }

    public static File promptForDirectory(Shell shell) {
        if (shell == null) {
            shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        DirectoryDialog dialog = new DirectoryDialog(shell);
        String lastSaveDirectory = PlatformUI.getPreferenceStore().getString(LAST_SAVE_DIRECTORY_LOCATION_IDENTIFIER);
        if (lastSaveDirectory != null && !lastSaveDirectory.isEmpty()) {
            dialog.setFilterPath(lastSaveDirectory);
        }
        shell.setEnabled(false);
        String selectedDirectory = dialog.open();
        shell.setEnabled(true);
        if (selectedDirectory == null) {
            return null;
        }
        File selectedDir = new File(selectedDirectory);
        PlatformUI.getPreferenceStore().setValue(LAST_SAVE_DIRECTORY_LOCATION_IDENTIFIER, selectedDir.getPath());
        if (!FileDialogHelper.isOkToOverwriteFilesInFolder(selectedDir, shell)) {
            return null;
        }
        return selectedDir;
    }

    public static boolean isOkToOverwriteFilesInFolder(File selectedDir, Shell shell) {
        if (selectedDir == null) {
            return false;
        }
        if (!selectedDir.isDirectory()) {
            return false;
        }
        @NonNull File @NonNull [] dirContents = (File[])NullUtils.neverNull((Object[])selectedDir.listFiles());
        if (dirContents.length > 0) {
            shell.setEnabled(false);
            boolean okToOverwrite = MessageDialog.openConfirm((Shell)shell, (String)"Confirm Overwrite", (String)("Directory '" + selectedDir.getAbsolutePath() + "' already contains files. Continuing may overwrite them."));
            shell.setEnabled(true);
            if (!okToOverwrite) {
                return false;
            }
        }
        return true;
    }

    public static void openFileAfterJobComplete(final @NonNull Job jobToWaitOn, final @NonNull File selectedFile) {
        Job job = new Job("Opening " + selectedFile.getAbsolutePath() + " after job completion"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    jobToWaitOn.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IStatus status = jobToWaitOn.getResult();
                if (status == Status.OK_STATUS && !monitor.isCanceled() && Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().open(selectedFile);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }
}

