/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.navigation.INavigationElement;
import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.FrameRenderPass;
import com.arm.mgd.core.target.data.FramebufferFeature;
import com.arm.mgd.ui.controllers.TraceOutlineItem;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.TreeItem;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DynamicTreeItemWrapper
extends TreeItem<TraceOutlineItem> {
    private int childrenComplete = 0;
    private @NonNull List<DynamicTreeItemWrapper> nodeChildren = NullUtils.EMPTY_LIST;
    private final @NonNull ObservableList<DynamicTreeItemWrapper> uiChildren = (ObservableList)NullUtils.neverNull((Object)FXCollections.observableArrayList());
    private final @NonNull FilteredList<DynamicTreeItemWrapper> filteredUIChildren = new FilteredList(this.uiChildren);
    private final @NonNull BooleanProperty filterChildren = new SimpleBooleanProperty();
    private static final @NonNull ShowOnlyInterestingFramesPredicate predicate = new ShowOnlyInterestingFramesPredicate();

    public DynamicTreeItemWrapper(@NonNull TraceOutlineItem wrappedItem) {
        super((Object)wrappedItem);
        ObservableList children = this.getChildren();
        Bindings.bindContent((List)children, this.filteredUIChildren);
        this.filterChildren.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue != null && newValue.booleanValue()) {
                    DynamicTreeItemWrapper.this.filteredUIChildren.setPredicate((Predicate)predicate);
                } else {
                    DynamicTreeItemWrapper.this.filteredUIChildren.setPredicate(null);
                }
            }
        });
    }

    public @NonNull BooleanProperty filterChildrenProperty() {
        return this.filterChildren;
    }

    public @Nullable DynamicTreeItemWrapper getTreeItem(INavigationElement<?> itemToFind) {
        if (((TraceOutlineItem)this.getValue()).equals(itemToFind)) {
            return this;
        }
        for (TreeItem child : this.uiChildren) {
            DynamicTreeItemWrapper item = (DynamicTreeItemWrapper)child;
            DynamicTreeItemWrapper result = item.getTreeItem(itemToFind);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void collapseAllChildren() {
        assert (Platform.isFxApplicationThread());
        for (TreeItem treeItem : this.nodeChildren) {
            ((DynamicTreeItemWrapper)treeItem).collapseAll();
        }
    }

    protected void collapseAll() {
        assert (Platform.isFxApplicationThread());
        this.setExpanded(false);
        for (TreeItem treeItem : this.nodeChildren) {
            ((DynamicTreeItemWrapper)treeItem).collapseAll();
        }
    }

    public @NonNull ObservableList<DynamicTreeItemWrapper> getFilteredChildren() {
        return this.filteredUIChildren;
    }

    public synchronized boolean refreshData(boolean addedToUI) {
        Object itemToAddOrUpdate;
        INavigationElement<?> wrappedItem = ((TraceOutlineItem)this.getValue()).getItem();
        if (wrappedItem == null) {
            return true;
        }
        boolean itemIsFinal = wrappedItem.isTheChildrenListFinal();
        List itemsChildren = wrappedItem.getChildren();
        int numberOfChildrenInItem = itemsChildren.size();
        if (itemIsFinal && this.nodeChildren.size() == numberOfChildrenInItem && this.nodeChildren.size() == this.childrenComplete) {
            return true;
        }
        int i = this.nodeChildren.size();
        while (i < numberOfChildrenInItem) {
            itemToAddOrUpdate = (INavigationElement)itemsChildren.get(i);
            assert (itemToAddOrUpdate != null);
            DynamicTreeItemWrapper newNode = new DynamicTreeItemWrapper(new TraceOutlineItem((INavigationElement<?>)itemToAddOrUpdate));
            newNode.filterChildren.bind((ObservableValue)this.filterChildren);
            if (this.nodeChildren == Collections.EMPTY_LIST) {
                this.nodeChildren = new ArrayList<DynamicTreeItemWrapper>();
            }
            this.nodeChildren.add(newNode);
            ++i;
        }
        this.pushChanges(addedToUI);
        i = this.childrenComplete;
        while (i < this.nodeChildren.size()) {
            itemToAddOrUpdate = this.nodeChildren.get(i);
            assert (itemToAddOrUpdate != null);
            if (((DynamicTreeItemWrapper)((Object)itemToAddOrUpdate)).refreshData(addedToUI) && this.childrenComplete == i) {
                ++this.childrenComplete;
            }
            ++i;
        }
        return false;
    }

    private void pushChanges(boolean addedToUI) {
        if (addedToUI) {
            Platform.runLater(() -> this.pushChanges());
        } else {
            this.pushChanges();
        }
    }

    private void pushChanges() {
        if (this.nodeChildren.size() != this.uiChildren.size()) {
            this.uiChildren.addAll(this.nodeChildren.subList(this.uiChildren.size(), this.nodeChildren.size()));
        }
    }

    private static class ShowOnlyInterestingFramesPredicate
    implements Predicate<TreeItem<TraceOutlineItem>> {
        private ShowOnlyInterestingFramesPredicate() {
        }

        @Override
        public boolean test(TreeItem<TraceOutlineItem> t) {
            INavigationElement<?> navigationElement = ((TraceOutlineItem)t.getValue()).getItem();
            if (navigationElement instanceof Frame) {
                FramebufferFeature.CaptureMode captureMode;
                Frame frame = (Frame)navigationElement;
                FrameRenderPass firstRenderPass = frame.getFirstRenderPass();
                FramebufferFeature.CaptureMode captureMode2 = captureMode = firstRenderPass != null ? firstRenderPass.getCaptureMode() : FramebufferFeature.CaptureMode.NONE;
                return frame.isCaptured() || frame.isReplayed() || captureMode != FramebufferFeature.CaptureMode.NONE || frame.hasMidstreamTraceData();
            }
            return true;
        }
    }
}

