/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import java.util.List;
import javafx.scene.control.TableCell;
import javafx.scene.text.Font;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class CustomFontTextTableCell<S, T>
extends TableCell<S, T> {
    public CustomFontTextTableCell() {
        String selectedFont = this.getSelectedFont();
        if (selectedFont != null) {
            this.setStyle("-fx-font-family: '" + selectedFont + "';");
        }
    }

    protected static @Nullable String getFirstAvailableFont(@NonNull List<@NonNull String> listOfFonts) {
        List availableFonts = Font.getFamilies();
        String selectedFont = null;
        for (String font : listOfFonts) {
            if (!availableFonts.contains(font)) continue;
            selectedFont = font;
            break;
        }
        return selectedFont;
    }

    protected abstract @Nullable String getSelectedFont();

    protected @Nullable String getTextFromItem(@NonNull T item) {
        return item.toString();
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(this.getTextFromItem(item));
        }
    }
}

