/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

public class BoundedRangeWindow {
    public final int windowStart;
    public final int windowEnd;

    public BoundedRangeWindow(int minimumValue, int maximumValue, int size, int centre) {
        if (minimumValue > maximumValue) {
            throw new IllegalArgumentException("Unable to create a range window: minimum bound > maximum bound.");
        }
        if ((long)size >= Math.abs((long)maximumValue - (long)minimumValue)) {
            this.windowEnd = maximumValue;
            this.windowStart = minimumValue;
            return;
        }
        if (centre > maximumValue) {
            centre = maximumValue;
        }
        if (centre < minimumValue) {
            centre = minimumValue;
        }
        int upper = centre;
        int lower = centre;
        boolean upperLimit = upper == maximumValue;
        boolean lowerLimit = lower == minimumValue;
        int remainingRange = size;
        while (!(remainingRange <= 0 || upperLimit && lowerLimit)) {
            if (!upperLimit) {
                --remainingRange;
                boolean bl = upperLimit = ++upper == maximumValue;
            }
            if (remainingRange <= 0 || lowerLimit) continue;
            --remainingRange;
            boolean bl = lowerLimit = --lower == minimumValue;
        }
        this.windowEnd = upper;
        this.windowStart = lower;
    }
}

