/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.export.VkImageAssetExporter;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.util.IAssetsCollectionGetter;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.ui.utils.IBackgroundAssetExporter;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public class BackgroundVkImageAssetExporter
implements IBackgroundAssetExporter<VkImageAsset> {
    @Override
    public @NonNull Job exportSelectedAssets(@NonNull Collection<@NonNull VkImageAsset> imageAssets, @NonNull File directory) {
        return BackgroundVkImageAssetExporter.exportSelectedImages((IAssetsCollectionGetter<VkImageAsset>)((IAssetsCollectionGetter)() -> imageAssets), directory);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Job exportAllAssetsAtFunction(@NonNull TraceDataModel model, int functionIndex, @NonNull File directory) {
        assert (model != null);
        assert (directory != null);
        assert (directory.isDirectory());
        assert (functionIndex < model.count());
        assert (functionIndex > 0);
        @NonNull IAssetsCollectionGetter getter = () -> {
            SynchronousTraceStateSnapshot tss = new SynchronousTraceStateSnapshot(model);
            tss.setSelectedFunction(functionIndex);
            AssetTable table = tss.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS.SPEC);
            ArrayList<@NonNull E> assets = new ArrayList(table.size());
            table.forEach(asset -> {
                boolean bl = assets.add((VkImageAsset)asset);
            });
            return assets;
        };
        return BackgroundVkImageAssetExporter.exportSelectedImages((IAssetsCollectionGetter<VkImageAsset>)getter, directory);
    }

    private static @NonNull Job exportSelectedImages(final @NonNull IAssetsCollectionGetter<@NonNull VkImageAsset> imageGetter, final @NonNull File directory) {
        assert (directory != null);
        assert (directory.isDirectory());
        Job job = new Job("Exporting Images"){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected IStatus run(IProgressMonitor monitor) {
                @NonNull Collection images = imageGetter.get();
                boolean success = VkImageAssetExporter.export((Collection)images, (File)directory, (ICoreProgressMonitor)new SimpleCoreProgressMonitor(monitor));
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return success ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }
}

