/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.export.GlTextureAssetExporter;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.IAssetsCollectionGetter;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.ui.utils.IBackgroundAssetExporter;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public class BackgroundGlTextureAssetExporter
implements IBackgroundAssetExporter<GlTextureAsset> {
    @Override
    public @NonNull Job exportSelectedAssets(@NonNull Collection<@NonNull GlTextureAsset> textureAssets, @NonNull File directory) {
        return BackgroundGlTextureAssetExporter.exportSelectedTextures((IAssetsCollectionGetter<GlTextureAsset>)((IAssetsCollectionGetter)() -> textureAssets), directory);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public @NonNull Job exportAllAssetsAtFunction(@NonNull TraceDataModel model, int functionIndex, @NonNull File directory) {
        assert (model != null);
        assert (directory != null);
        assert (directory.isDirectory());
        assert (functionIndex < model.count());
        assert (functionIndex > 0);
        @NonNull IAssetsCollectionGetter getter = IAssetsCollectionGetter.getAssetsAtFunctionCall((TraceDataModel)model, (int)functionIndex, (AssetTableSpec)KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC, t -> true);
        return BackgroundGlTextureAssetExporter.exportSelectedTextures((IAssetsCollectionGetter<GlTextureAsset>)getter, directory);
    }

    private static @NonNull Job exportSelectedTextures(final @NonNull IAssetsCollectionGetter<@NonNull GlTextureAsset> textureGetter, final @NonNull File directory) {
        assert (directory != null);
        assert (directory.isDirectory());
        Job job = new Job("Exporting Textures"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean result = GlTextureAssetExporter.export((Collection)textureGetter.get(), (File)directory, (ICoreProgressMonitor)new SimpleCoreProgressMonitor(monitor));
                return result ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }
}

