/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;

public class AssetUtils {
    public static <T extends IAssetItem> @NonNull Map<String, T> getLabelAssetMap(@NonNull Class<T> clazz, @NonNull AssetTableSpec tableSpec, @NonNull TraceStateSnapshot snapshot) {
        LinkedHashMap<String, IAssetItem> result = new LinkedHashMap<String, IAssetItem>();
        AssetTable table = snapshot.getAssetTableBySpec(tableSpec);
        Comparator<@NonNull T> comparator = new Comparator<T>(){

            @Override
            public int compare(@NonNull T o1, @NonNull T o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };
        TreeSet<@NonNull E> sortedAssets = new TreeSet(comparator);
        sortedAssets.addAll(table.asCollection());
        for (IAssetItem asset : sortedAssets) {
            result.put(asset.getLabelText(), asset);
        }
        return result;
    }
}

