/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.utils.NullUtils;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class ArgumentHierarchyTruncationPrinter {
    public static @NonNull String printTruncatedArgumentHierarchy(@NonNull ArgumentHierarchyNode hierarchy, int targetMaxCharacters) {
        StringBuilder sb = new StringBuilder();
        ArgumentHierarchyTruncationPrinter.printUpToLimit(hierarchy, sb, targetMaxCharacters);
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    private static void printUpToLimit(@NonNull ArgumentHierarchyNode node, StringBuilder sb, int targetMaxCharacters) {
        if (node instanceof ArgumentHierarchyBranch) {
            ArgumentHierarchyTruncationPrinter.printUpToLimit((ArgumentHierarchyBranch)node, sb, targetMaxCharacters);
        } else if (node instanceof ArgumentHierarchyLeaf) {
            ArgumentHierarchyTruncationPrinter.printValue((ArgumentHierarchyLeaf)node, sb);
        }
    }

    private static String printChildrenTrucated(ArgumentHierarchyBranch.BranchType type, @NonNull List<@NonNull ArgumentHierarchyNode> children) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getOpenHierarchy());
        sb.append(children.size()).append(" ").append(children.size() == 1 ? type.getSingularChildName() : type.getPluralChildName()).append("...");
        sb.append(type.getCloseHierarchy());
        return sb.toString();
    }

    private static String printChildrenUpToLimit(ArgumentHierarchyBranch.BranchType type, @NonNull List<@NonNull ArgumentHierarchyNode> children, int targetMaxCharacters) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getOpenHierarchy());
        int i = 0;
        while (i < children.size()) {
            ArgumentHierarchyNode argument;
            String argumentName;
            if (i > 0) {
                sb.append(type.getChildrenSeparator());
            }
            if ((argumentName = (argument = children.get(i)).getName()) != null) {
                sb.append(argumentName).append('=');
            }
            ArgumentHierarchyTruncationPrinter.printUpToLimit(argument, sb, targetMaxCharacters - 1);
            ++i;
        }
        sb.append(type.getCloseHierarchy());
        return sb.toString();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void printUpToLimit(@NonNull ArgumentHierarchyBranch hierarchy, StringBuilder sb, int stringLengthLimit) {
        boolean avoidTruncationAtThisLevel;
        @NonNull List children = hierarchy.getChildren();
        ArgumentHierarchyBranch.BranchType type = hierarchy.getType();
        boolean hasNoArgs = children.size() == 0;
        boolean hasSingleArgumentWithValue = children.size() == 1 && ((ArgumentHierarchyNode)children.get(0)).hasValue();
        boolean bl = avoidTruncationAtThisLevel = type == ArgumentHierarchyBranch.BranchType.FUNCTION || hasNoArgs || hasSingleArgumentWithValue;
        if (type == ArgumentHierarchyBranch.BranchType.FUNCTION) {
            sb.append(hierarchy.getName());
        }
        int remainingCharacters = stringLengthLimit - sb.length();
        String full = ArgumentHierarchyTruncationPrinter.printChildrenUpToLimit(type, children, remainingCharacters);
        if (avoidTruncationAtThisLevel || full.length() <= remainingCharacters) {
            sb.append(full);
        } else {
            String truncated = ArgumentHierarchyTruncationPrinter.printChildrenTrucated(type, children);
            if (truncated.length() > full.length()) {
                sb.append(full);
            } else {
                sb.append(truncated);
            }
        }
    }

    private static void printValue(@NonNull ArgumentHierarchyLeaf hierarchy, StringBuilder sb) {
        String value = hierarchy.getValue();
        if (hierarchy.getType() == ArgumentHierarchyLeaf.LeafType.STRING) {
            boolean bothEndOfLineCharsFound;
            sb.append("\"");
            int firstCR = value.indexOf(13);
            int firstLF = value.indexOf(10);
            boolean bl = bothEndOfLineCharsFound = firstCR > -1 && firstLF > -1;
            if (bothEndOfLineCharsFound) {
                sb.append(value.substring(0, firstCR < firstLF ? firstCR : firstLF)).append("...");
            } else if (firstCR > -1) {
                sb.append(value.substring(0, firstCR)).append("...");
            } else if (firstLF > -1) {
                sb.append(value.substring(0, firstLF)).append("...");
            } else {
                sb.append(value);
            }
            sb.append("\"");
        } else {
            sb.append(value);
        }
    }
}

