/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.utils;

import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.utils.NullUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ArgumentHierarchyHTMLPrinter
implements ArgumentHierarchyNode.IArgumentHierarchyVisitor {
    private @NonNull StringBuilder stringBuilder = new StringBuilder();
    private int nestedLevel = 0;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ArgumentHierarchyBranch.BranchType previousBranchType;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ArgumentHierarchyBranch.BranchType currentBranchType;
    private static final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ArgumentHierarchyBranch.BranchType, @NonNull HierarchyPrintInformation> NodeToHTMLMap = new EnumMap<ArgumentHierarchyBranch.BranchType, HierarchyPrintInformation>(ArgumentHierarchyBranch.BranchType.class){
        private static final long serialVersionUID = -1195910448418065532L;
        {
            this.put(ArgumentHierarchyBranch.BranchType.FUNCTION, HierarchyPrintInformation.FUNCTION);
            this.put(ArgumentHierarchyBranch.BranchType.ARRAY, HierarchyPrintInformation.ARRAY);
            this.put(ArgumentHierarchyBranch.BranchType.STRUCT, HierarchyPrintInformation.STRUCT);
            this.put(ArgumentHierarchyBranch.BranchType.BITFIELD, HierarchyPrintInformation.BITFIELD);
        }
    };

    public void reset() {
        this.nestedLevel = 0;
        this.stringBuilder.setLength(0);
        this.currentBranchType = null;
        this.previousBranchType = null;
    }

    private static void appendIndent(@NonNull StringBuilder stringBuilder, int nestedLevel) {
        int i = 0;
        while (i < nestedLevel) {
            stringBuilder.append("    ");
            ++i;
        }
    }

    private static void appendLines(@NonNull StringBuilder stringBuilder, String[] valueLines, String separator, int nestedLevel) {
        int lineIndex = 0;
        while (lineIndex < valueLines.length) {
            if (lineIndex != 0) {
                ArgumentHierarchyHTMLPrinter.appendIndent(stringBuilder, nestedLevel);
            }
            stringBuilder.append(valueLines[lineIndex]);
            if (lineIndex != valueLines.length - 1) {
                stringBuilder.append(separator);
            }
            ++lineIndex;
        }
    }

    private static @Nullable String getNameClass(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ArgumentHierarchyBranch.BranchType branchType, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ArgumentHierarchyBranch.BranchType parentBranchType) {
        if (parentBranchType != null) {
            @NonNull HierarchyPrintInformation hierarchyPrintInformation = (HierarchyPrintInformation)((Object)NullUtils.neverNull((Object)((Object)NodeToHTMLMap.get(parentBranchType))));
            return hierarchyPrintInformation.childNameClass;
        }
        if (branchType != null) {
            @NonNull HierarchyPrintInformation hierarchyPrintInformation = (HierarchyPrintInformation)((Object)NullUtils.neverNull((Object)((Object)NodeToHTMLMap.get(branchType))));
            return hierarchyPrintInformation.nameClass;
        }
        return null;
    }

    private static void printName(@NonNull StringBuilder sb, @Nullable String name, @Nullable String nameClass, boolean printAssignment) {
        if (name == null) {
            return;
        }
        if (nameClass != null) {
            sb.append("<name class=\"").append(nameClass).append("\">");
        }
        sb.append(name);
        if (nameClass != null) {
            sb.append("</name>");
        }
        if (printAssignment) {
            sb.append(" = ");
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void visitBranch(@NonNull ArgumentHierarchyBranch branch) {
        @NonNull List arguments = branch.getChildren();
        ArgumentHierarchyBranch.BranchType type = branch.getType();
        ArgumentHierarchyHTMLPrinter.printName(this.stringBuilder, branch.getName(), ArgumentHierarchyHTMLPrinter.getNameClass(type, this.currentBranchType), type.childrenAreAssigned());
        if (arguments.size() == 0) {
            this.stringBuilder.append(type.getOpenHierarchy());
            return;
        }
        this.stringBuilder.append("\n");
        ArgumentHierarchyHTMLPrinter.appendIndent(this.stringBuilder, this.nestedLevel);
        this.stringBuilder.append(type.getOpenHierarchy());
        ++this.nestedLevel;
        this.stringBuilder.append("\n");
        ArgumentHierarchyHTMLPrinter.appendIndent(this.stringBuilder, this.nestedLevel);
        this.previousBranchType = this.currentBranchType;
        this.currentBranchType = type;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void leaveBranch(@NonNull ArgumentHierarchyBranch branch) {
        @NonNull List arguments = branch.getChildren();
        ArgumentHierarchyBranch.BranchType type = branch.getType();
        if (arguments.size() == 0) {
            this.stringBuilder.append(type.getCloseHierarchy());
            return;
        }
        --this.nestedLevel;
        this.currentBranchType = this.previousBranchType;
        this.stringBuilder.append("\n");
        ArgumentHierarchyHTMLPrinter.appendIndent(this.stringBuilder, this.nestedLevel);
        this.stringBuilder.append(type.getCloseHierarchy());
    }

    public void visit(@NonNull ArgumentHierarchyLeaf leaf) {
        ArgumentHierarchyHTMLPrinter.printName(this.stringBuilder, leaf.getName(), ArgumentHierarchyHTMLPrinter.getNameClass(null, this.currentBranchType), true);
        String value = StringEscapeUtils.escapeXml10((String)leaf.getValue());
        ArgumentHierarchyLeaf.LeafType type = leaf.getType();
        String tag = "";
        switch (type) {
            case FLOAT: {
                tag = "float";
                break;
            }
            case ENUM: {
                tag = "enum";
                break;
            }
            case INTEGER: {
                tag = "integer";
                break;
            }
            case POINTER: {
                tag = "pointer";
                break;
            }
            case STRING: {
                tag = "string";
                String[] valueLines = value.split("\n", -1);
                StringBuilder stringSb = new StringBuilder();
                stringSb.append("\"");
                ArgumentHierarchyHTMLPrinter.appendLines(stringSb, valueLines, "\n", this.nestedLevel);
                stringSb.append("\"");
                value = stringSb.toString();
                break;
            }
            default: {
                assert (false) : "Impossible code path";
                tag = "";
            }
        }
        this.stringBuilder.append("<").append(tag).append(">");
        this.stringBuilder.append(value);
        this.stringBuilder.append("</").append(tag).append(">");
    }

    public void betweenBranchChildren(@NonNull ArgumentHierarchyBranch branch) {
        this.stringBuilder.append(branch.getType().getChildrenSeparator());
        this.stringBuilder.append("\n");
        ArgumentHierarchyHTMLPrinter.appendIndent(this.stringBuilder, this.nestedLevel);
    }

    public @NonNull String getHTML() {
        return (String)NullUtils.neverNull((Object)this.stringBuilder.toString());
    }

    private static enum HierarchyPrintInformation {
        FUNCTION("function", "arg"),
        STRUCT(null, "member"),
        ARRAY(null, null),
        BITFIELD(null, null);

        private final @Nullable String nameClass;
        private final @Nullable String childNameClass;

        private HierarchyPrintInformation(String nameClass, String childNameClass) {
            this.nameClass = nameClass;
            this.childNameClass = childNameClass;
        }
    }
}

