/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.targetconn;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IAndroidPackageTraceManager;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.connection.LiveConnection;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.io.live.InterceptorCaptureState;
import com.arm.mgd.core.target.io.live.InterceptorStateListener;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.WeakListenerSet;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.editorinput.TargetEditorInput;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.FileTargetConnection;
import com.arm.mgd.ui.targetconn.IConnectionManagerListener;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionInterceptorStateListener;
import com.arm.mgd.ui.views.TraceEditor;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ui.IEditorInput;

public class TargetConnectionManager {
    private static final List<AbstractTargetConnection> connections = new ArrayList<AbstractTargetConnection>();
    private static final List<IAndroidPackageTraceManager> traceManagers = new ArrayList<IAndroidPackageTraceManager>();
    private static final Set<TraceEditor> editors = new HashSet<TraceEditor>();
    private static final Set<TargetConnectionInterceptorStateListener> targetConnectionInterceptorStateListeners = new HashSet<TargetConnectionInterceptorStateListener>();
    private static final @NonNull WeakListenerSet<IConnectionManagerListener> connectionManagerListeners = new WeakListenerSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTargetConnectionInterceptorStateListener(@NonNull TargetConnectionInterceptorStateListener listener) {
        Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
        synchronized (set) {
            targetConnectionInterceptorStateListeners.add(listener);
        }
    }

    public static @Nullable FileTargetConnection createFileConnection(@NonNull File targetFile, @NonNull IProgressMonitor progressMonitor, long totalBytes, int nUnitsThisFile) throws IOException, ProtocolVersionException {
        FileTargetConnection result = FileTargetConnection.read(targetFile, progressMonitor, totalBytes, nUnitsThisFile);
        if (result != null) {
            TargetConnectionManager.addNewConnection(result);
            TargetConnectionManager.notifyFileLoaded(result);
        }
        return result;
    }

    public static @NonNull LiveTargetConnection createLiveConnection(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice, @Nullable IAndroidPackageTraceManager traceManager) throws LiveTargetConnection.ConnectionFailedException {
        LiveTargetConnection targetConnection = LiveTargetConnection.create(targetIP, targetPort, adbDevice);
        TargetConnectionManager.addNewConnection(targetConnection);
        TargetConnectionManager.notifyNewConnection(targetConnection);
        if (adbDevice != null && traceManager != null) {
            traceManagers.add(traceManager);
        }
        return targetConnection;
    }

    public static @NonNull LiveTargetConnection getLiveConnectionToDaemon(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice) throws LiveTargetConnection.ConnectionFailedException {
        return LiveTargetConnection.createConnectionWithName(targetIP, targetPort, adbDevice, "DaemonConnection", "DaemonConnection error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable TraceEditor findEditorForModel(@NonNull TraceDataModel model) {
        Set<TraceEditor> set = editors;
        synchronized (set) {
            for (TraceEditor editor : editors) {
                if (!editor.getTarget().equals(model.getParentProcessTarget().getParentTarget())) continue;
                return editor;
            }
        }
        return null;
    }

    public static @Nullable AbstractTargetConnection getCurrentConnection() {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        TraceEditor activeEditor = activator.getActiveTraceEditor();
        if (activeEditor == null) {
            return null;
        }
        IEditorInput input = activeEditor.getEditorInput();
        if (input == null || !(input instanceof TargetEditorInput.ProxyTargetEditor)) {
            return null;
        }
        TargetEditorInput targetEditorInput = ((TargetEditorInput.ProxyTargetEditor)input).getEditor();
        return targetEditorInput != null ? targetEditorInput.getTargetConnection() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable LiveTargetConnection getLiveConnectionToAddress(@NonNull SocketAddress address) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            for (AbstractTargetConnection connection : connections) {
                if (!(connection instanceof LiveTargetConnection) || !address.equals(((LiveConnection)connection.getTarget().getConnection()).getSocketAddress()) || !connection.isActive()) continue;
                return (LiveTargetConnection)connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable LiveTargetConnection getLiveConnectionToADBDevice(@NonNull ADBDevice adbDevice) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            for (AbstractTargetConnection connection : connections) {
                if (!(connection instanceof LiveTargetConnection) || !adbDevice.equals((Object)((LiveTargetConnection)connection).getADBDevice()) || !connection.isActive()) continue;
                return (LiveTargetConnection)connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable LiveTargetConnection getPastConnectionToADBDevice(@NonNull ADBDevice adbDevice) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            for (AbstractTargetConnection connection : connections) {
                if (!(connection instanceof LiveTargetConnection) || !adbDevice.equals((Object)((LiveTargetConnection)connection).getADBDevice())) continue;
                return (LiveTargetConnection)connection;
            }
        }
        return null;
    }

    public static void cleanupPastConnectionToADBDevice(@NonNull ADBDevice adbDevice, @NonNull ICoreProgressMonitor progressMonitor) {
        @Nullable LiveTargetConnection pastConnection = TargetConnectionManager.getPastConnectionToADBDevice(adbDevice);
        if (pastConnection != null) {
            TargetConnectionManager.releaseConnection(pastConnection, progressMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mapEditor(TraceEditor part) {
        Set<TraceEditor> set = editors;
        synchronized (set) {
            editors.add(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseAllLiveTraces() {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            for (AbstractTargetConnection connection : connections) {
                if (!connection.canPause(false)) continue;
                connection.pause(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(@NonNull AbstractTargetConnection connection, @NonNull ICoreProgressMonitor monitor) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            if (connections.contains(connection)) {
                block10: {
                    IAndroidPackageTraceManager traceManager;
                    ADBDevice device;
                    if (connection instanceof LiveTargetConnection && (device = ((LiveTargetConnection)connection).getADBDevice()) != null && (traceManager = TargetConnectionManager.getTraceManager(device)) != null) {
                        try {
                            try {
                                traceManager.setProgressMonitor(monitor);
                                traceManager.close();
                            }
                            catch (IADBTask.ADBException exception) {
                                CoreLogging.warning((ICoreLoggingSource)connection, (String)((String)NullUtils.neverNull((Object)exception.getMessage())));
                                traceManagers.remove(traceManager);
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            traceManagers.remove(traceManager);
                            throw throwable;
                        }
                        traceManagers.remove(traceManager);
                    }
                }
                connections.remove(connection);
            }
        }
    }

    private static @Nullable IAndroidPackageTraceManager getTraceManager(@NonNull ADBDevice device) {
        for (IAndroidPackageTraceManager traceManager : traceManagers) {
            if (!traceManager.getDevice().equals((Object)device)) continue;
            return traceManager;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTargetConnectionInterceptorStateListener(@NonNull TargetConnectionInterceptorStateListener listener) {
        Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
        synchronized (set) {
            targetConnectionInterceptorStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unmapEditor(TraceEditor part) {
        Set<TraceEditor> set = editors;
        synchronized (set) {
            editors.remove(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNewConnection(@NonNull AbstractTargetConnection connection) {
        List<AbstractTargetConnection> list = connections;
        synchronized (list) {
            connections.add(connection);
        }
        if (connection instanceof LiveTargetConnection) {
            @NonNull LiveTargetConnection liveTargetConnection = (LiveTargetConnection)connection;
            @NonNull LiveTarget liveTarget = (LiveTarget)liveTargetConnection.getTarget();
            liveTarget.addInterceptorStateListener((InterceptorStateListener)new PerConnectionInterceptorStateListener(liveTargetConnection));
        }
    }

    public static void addConnectionManagerListener(@NonNull IConnectionManagerListener connectionManagerListener) {
        connectionManagerListeners.addListenerAsWeakReference((Object)connectionManagerListener);
    }

    public static void removeConnectionManagerListener(@NonNull IConnectionManagerListener connectionManagerListener) {
        connectionManagerListeners.removeWeakReference((Object)connectionManagerListener);
    }

    public static void notifyNewConnection(@NonNull LiveTargetConnection newConnection) {
        connectionManagerListeners.notifyWeakListeners(listener -> listener.onNewConnection(newConnection));
    }

    public static void notifyFileLoaded(@NonNull FileTargetConnection file) {
        connectionManagerListeners.notifyWeakListeners(listener -> listener.onFileLoaded(file));
    }

    private static class PerConnectionInterceptorStateListener
    implements InterceptorStateListener {
        private final @NonNull LiveTargetConnection target;

        public PerConnectionInterceptorStateListener(@NonNull LiveTargetConnection target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTargetModifyStateChanged(ModifyStateInterceptorCommand newState) {
            if (this.isCurrentTarget()) {
                Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
                synchronized (set) {
                    for (TargetConnectionInterceptorStateListener listener : targetConnectionInterceptorStateListeners) {
                        listener.onTargetModifyStateChanged(newState);
                    }
                }
            }
        }

        private boolean isCurrentTarget() {
            return TargetConnectionManager.getCurrentConnection() == this.target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInterceptorStateChanged(@NonNull InterceptorExecutionState oldState, @NonNull InterceptorExecutionState newState, int processID) {
            if (this.isCurrentTarget()) {
                Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
                synchronized (set) {
                    for (TargetConnectionInterceptorStateListener listener : targetConnectionInterceptorStateListeners) {
                        listener.onInterceptorStateChanged(oldState, newState, processID);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onInterceptorCaptureStateChanged(@NonNull InterceptorCaptureState oldState, @NonNull InterceptorCaptureState newState) {
            if (this.isCurrentTarget()) {
                Set<TargetConnectionInterceptorStateListener> set = targetConnectionInterceptorStateListeners;
                synchronized (set) {
                    for (TargetConnectionInterceptorStateListener listener : targetConnectionInterceptorStateListeners) {
                        listener.onInterceptorCaptureStateChanged(oldState, newState);
                    }
                }
            }
        }
    }
}

