/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.targetconn;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.handlers.ConnectTargetHandler;
import com.arm.mgd.ui.handlers.DisconnectTargetHandler;
import com.arm.mgd.ui.targetconn.LiveConnectionSettings;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ui.IWorkbenchWindow;

public class RemoteControl {
    private static final String COMMAND_LINE_FLAG = "--remote-control";
    private static final byte[] CURRENT_MGD_REMOTE_VERSION = "mgd-0001\r\n".getBytes(Charset.forName("ASCII"));
    private static IWorkbenchWindow editorWindow;
    private static final int PORT = 1989;
    private static ImplThread thread;
    private static @NonNull String currentIP;
    private static int currentPort;

    static {
        thread = null;
        currentIP = LiveConnectionSettings.getIPAddress();
        currentPort = LiveConnectionSettings.getPort();
    }

    public static synchronized void start(@NonNull IWorkbenchWindow window) throws IOException {
        if (thread == null) {
            editorWindow = window;
            thread = new ImplThread();
            thread.setDaemon(true);
            thread.start();
        }
    }

    public static synchronized void stop() throws InterruptedException {
        if (thread != null) {
            thread.terminate();
            thread.join();
            thread = null;
        }
    }

    private static void connect() {
        new Thread(() -> ConnectTargetHandler.doConnectTargetSynchronous(currentIP, currentPort, null, null, null, (IWorkbenchWindow)NullUtils.neverNull((Object)editorWindow))).start();
        RemoteControl.raiseWindow();
    }

    private static void disconnect() {
        DisconnectTargetHandler.disconnectTarget();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void listen(@NonNull ServerSocket server) {
        if (!RemoteControl.$assertionsDisabled && RemoteControl.CURRENT_MGD_REMOTE_VERSION.length != 10) {
            throw new AssertionError();
        }
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                var1_1 = null;
                var2_4 = null;
                try {
                    socket = server.accept();
                    try {
                        block30: {
                            reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                            try {
                                block29: {
                                    outputStream = socket.getOutputStream();
                                    try {
                                        writer = new PrintWriter(new OutputStreamWriter(outputStream));
                                        try {
                                            outputStream.write(RemoteControl.CURRENT_MGD_REMOTE_VERSION);
                                            productVersionString = String.format("%s\r\n", new Object[]{VersionProperties.PRODUCT_NAME_AND_VERSION});
                                            outputStream.write(productVersionString.getBytes());
                                            outputStream.flush();
                                            while ((line = reader.readLine()) != null) {
                                                result = RemoteControl.processCommand(line.split(" "));
                                                if (result != CommandResult.SUCCESS) {
                                                    CoreLogging.warning(null, (String)("Failed to process Streamline remote command: " + (Object)result));
                                                }
                                                writer.print(String.valueOf(result.getResponseString()) + "\n");
                                                writer.flush();
                                            }
                                        }
                                        finally {
                                            if (writer != null) {
                                                writer.close();
                                            }
                                        }
                                        if (outputStream == null) break block29;
                                    }
                                    catch (Throwable var2_5) {
                                        if (var1_1 == null) {
                                            var1_1 = var2_5;
                                        } else if (var1_1 != var2_5) {
                                            var1_1.addSuppressed(var2_5);
                                        }
                                        if (outputStream == null) throw var1_1;
                                        outputStream.close();
                                        throw var1_1;
                                    }
                                    outputStream.close();
                                }
                                if (reader == null) break block30;
                            }
                            catch (Throwable var2_6) {
                                if (var1_1 == null) {
                                    var1_1 = var2_6;
                                } else if (var1_1 != var2_6) {
                                    var1_1.addSuppressed(var2_6);
                                }
                                if (reader == null) throw var1_1;
                                reader.close();
                                throw var1_1;
                            }
                            reader.close();
                        }
                        if (socket == null) continue;
                    }
                    catch (Throwable var2_7) {
                        if (var1_1 == null) {
                            var1_1 = var2_7;
                        } else if (var1_1 != var2_7) {
                            var1_1.addSuppressed(var2_7);
                        }
                        if (socket == null) throw var1_1;
                        socket.close();
                        throw var1_1;
                    }
                    socket.close();
                    continue;
                }
                catch (Throwable var2_8) {
                    if (var1_1 == null) {
                        var1_1 = var2_8;
                        throw var1_1;
                    }
                    if (var1_1 == var2_8) throw var1_1;
                    var1_1.addSuppressed(var2_8);
                    throw var1_1;
                }
                break;
            }
        }
        catch (IOException var1_3) {
            return;
        }
        {
            ** while (true)
        }
    }

    private static CommandResult processCommand(String[] commandParts) {
        block13: {
            assert (commandParts.length > 0);
            String command = commandParts[0];
            try {
                if (command.equals("CONNECT")) {
                    if (commandParts.length > 3) {
                        return CommandResult.TOO_MANY_ARGUMENTS;
                    }
                    if (commandParts.length < 2) {
                        return CommandResult.BAD_COMMAND;
                    }
                    RemoteControl.setAddressAndPort((String)NullUtils.neverNull((Object)commandParts[1]));
                    RemoteControl.connect();
                    break block13;
                }
                if (command.equals("SET")) {
                    if (commandParts.length > 2) {
                        return CommandResult.TOO_MANY_ARGUMENTS;
                    }
                    if (commandParts.length < 2) {
                        return CommandResult.BAD_ADDRESS;
                    }
                    RemoteControl.setAddressAndPort((String)NullUtils.neverNull((Object)commandParts[1]));
                    break block13;
                }
                if (command.equals("DISCONNECT")) {
                    if (commandParts.length > 1) {
                        return CommandResult.TOO_MANY_ARGUMENTS;
                    }
                    RemoteControl.disconnect();
                    break block13;
                }
                if (command.equals("RAISE")) {
                    if (commandParts.length > 1) {
                        return CommandResult.TOO_MANY_ARGUMENTS;
                    }
                    RemoteControl.raiseWindow();
                    break block13;
                }
                return CommandResult.BAD_COMMAND;
            }
            catch (ErrorException e) {
                return e.getCommandResult();
            }
        }
        return CommandResult.SUCCESS;
    }

    private static void processCommandLineArgs() {
        String[] args = Platform.getApplicationArgs();
        int remoteArgsBegin = -1;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(COMMAND_LINE_FLAG)) {
                remoteArgsBegin = i + 1;
                break;
            }
            ++i;
        }
        if (remoteArgsBegin != -1) {
            int numRemoteArgs = args.length - remoteArgsBegin;
            if (numRemoteArgs > 0) {
                String[] commandParts = new String[numRemoteArgs];
                System.arraycopy(args, remoteArgsBegin, commandParts, 0, numRemoteArgs);
                RemoteControl.processCommand(commandParts);
            } else {
                CoreLogging.warning(null, (String)"Missing arguments to --remote-control argument");
            }
        }
    }

    private static void raiseWindow() {
        editorWindow.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                editorWindow.getShell().forceActive();
            }
        });
    }

    private static void setAddressAndPort(@NonNull String addressPort) throws ErrorException {
        String[] addressPortArray = addressPort.split(":");
        if (addressPortArray.length == 1 || addressPortArray.length == 2) {
            try {
                String address = addressPortArray[0];
                int port = addressPortArray.length == 2 ? Integer.parseInt(addressPortArray[1]) : 5002;
                currentIP = (String)NullUtils.neverNull((Object)address);
                currentPort = port;
            }
            catch (NumberFormatException e) {
                throw new ErrorException(CommandResult.BAD_PORT);
            }
        } else {
            throw new ErrorException(CommandResult.BAD_COMMAND);
        }
    }

    private static enum CommandResult {
        BAD_ADDRESS,
        BAD_COMMAND,
        BAD_PORT,
        BAD_START_TIME,
        SUCCESS,
        TOO_MANY_ARGUMENTS;


        public String getResponseString() {
            return this.name();
        }
    }

    private static class ErrorException
    extends Exception {
        private static final long serialVersionUID = 9697069L;
        private final @NonNull CommandResult commandResult;

        public ErrorException(@NonNull CommandResult commandResult) {
            this.commandResult = commandResult;
        }

        public @NonNull CommandResult getCommandResult() {
            return this.commandResult;
        }
    }

    private static class ImplThread
    extends Thread {
        private final @NonNull ServerSocket server = new ServerSocket(1989);

        @Override
        public void run() {
            try {
                RemoteControl.processCommandLineArgs();
                RemoteControl.listen(this.server);
            }
            catch (Throwable t) {
                CoreLogging.severeNoAssert(null, (Throwable)t, (String)"Failed to execute streamline remote control command");
            }
        }

        public void terminate() {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

