/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.targetconn;

import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.LiveProcessTarget;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.LiveTargetGlobalState;
import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.connection.InvalidProtocolVersionException;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.LiveConnectionSettings;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveTargetConnection
extends AbstractTargetConnection {
    private static final int ADB_FORWARDING_CONNECT_TIMEOUT_MS = 5000;
    private static final int DAEMON_SOCKET_CONNECT_RETRY_COUNT = 12;
    private static final int DAEMON_SOCKET_CONNECT_POLL_DELAY = 500;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static int traceNumberCounter = 0;
    private final @NonNull Date timestamp = new Date();
    private final int traceNumber = LiveTargetConnection.allocateTraceCounter();
    private final @Nullable ADBDevice androidDevice;

    static @NonNull LiveTargetConnection create(@NonNull String targetIP, int targetPort, @Nullable ADBDevice androidDevice) throws ConnectionFailedException {
        String connectionErrorName;
        String connectionName;
        if (androidDevice != null) {
            connectionName = androidDevice.getUnambiguousName();
            connectionErrorName = androidDevice.toString();
        } else {
            connectionName = NullUtils.formattedString((String)"Target@%s:%s", (Object[])new Object[]{targetIP, NullUtils.stringValueOf((long)targetPort)});
            connectionErrorName = NullUtils.formattedString((String)"%s:%s", (Object[])new Object[]{targetIP, NullUtils.stringValueOf((long)targetPort)});
        }
        return LiveTargetConnection.createConnectionWithName(targetIP, targetPort, androidDevice, connectionName, connectionErrorName);
    }

    static @NonNull LiveTargetConnection createConnectionWithName(@NonNull String targetIP, int targetPort, @Nullable ADBDevice androidDevice, @NonNull String connectionName, @NonNull String connectionErrorName) throws ConnectionFailedException {
        InetSocketAddress address = new InetSocketAddress(targetIP, targetPort);
        boolean alreadyConnected = false;
        if (androidDevice != null) {
            alreadyConnected = TargetConnectionManager.getLiveConnectionToADBDevice(androidDevice) != null;
        } else {
            boolean bl = alreadyConnected = TargetConnectionManager.getLiveConnectionToAddress(address) != null;
        }
        if (alreadyConnected) {
            throw new ConnectionFailedException(NullUtils.formattedString((String)"You already have a live connection running on %s.", (Object[])new Object[]{connectionErrorName}));
        }
        try {
            @NonNull LiveTarget liveTarget = LiveTarget.get((SocketAddress)address, (int)12, (int)5000, (int)500, (String)connectionName, (ProcessConfig)LiveConnectionSettings.getDefaultProcessConfig());
            liveTarget.asyncRead();
            return new LiveTargetConnection(liveTarget, androidDevice);
        }
        catch (SocketTimeoutException timex) {
            throw new ConnectionFailedException(NullUtils.formattedString((String)"Connection timed-out when connecting to %s.\n\nCould not locate the network connection.", (Object[])new Object[]{connectionErrorName}));
        }
        catch (InvalidProtocolVersionException invalidVersionException) {
            throw new ConnectionFailedException(invalidVersionException.getMessage());
        }
        catch (ProtocolVersionException versionException) {
            throw new ConnectionFailedException(NullUtils.formattedString((String)"Connection refused when connecting to %s.\n\n%s", (Object[])new Object[]{connectionErrorName, NullUtils.neverNull((Object)versionException.getMessage())}));
        }
        catch (Exception e) {
            @NonNull String errorMessage = (String)NullUtils.neverNull((Object)(e.getMessage() != null ? String.format("%s\n\n", e.getMessage()) : ""));
            throw new ConnectionFailedException(NullUtils.formattedString((String)"%sCannot connect to %s.\n\nEither the network connection to your target device is not working or the daemon is not running on the target.", (Object[])new Object[]{errorMessage, connectionErrorName}));
        }
    }

    private LiveTargetConnection(@NonNull LiveTarget target, @Nullable ADBDevice androidDevice) {
        super((AbstractTarget)target, null);
        this.androidDevice = androidDevice;
    }

    private static synchronized int allocateTraceCounter() {
        return ++traceNumberCounter;
    }

    private @Nullable LiveProcessTarget getLiveProcessTarget() {
        return (LiveProcessTarget)this.getTarget().getActiveProcessTarget();
    }

    public @Nullable ADBDevice getADBDevice() {
        return this.androidDevice;
    }

    @Override
    public boolean canCaptureFrame() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.canCaptureFrame() : false;
    }

    @Override
    public boolean canEnableModifyStateFeature(ModifyStateInterceptorCommand feature) {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.canEnableModifyStateFeature(feature) : false;
    }

    @Override
    public boolean canPause(boolean currentProcess) {
        if (currentProcess) {
            LiveProcessTarget lpt = this.getLiveProcessTarget();
            return lpt != null ? lpt.canPause() : false;
        }
        return this.isActive();
    }

    @Override
    public boolean canResume() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.canResume() : false;
    }

    @Override
    public void captureFrame() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.captureFrame();
        }
    }

    @Override
    public void addAutomatedTraceCommand(AutomatedTraceCommand command) {
        LiveProcessTarget liveProcessTarget = this.getLiveProcessTarget();
        if (liveProcessTarget != null) {
            try {
                liveProcessTarget.sendAddAutomatedTraceCommand(command);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending add deferred command failed");
            }
        }
    }

    @Override
    public void deleteAutomatedTraceCommand(AutomatedTraceCommand command) {
        LiveProcessTarget liveProcessTarget = this.getLiveProcessTarget();
        if (liveProcessTarget != null) {
            try {
                liveProcessTarget.sendDeleteAutomatedTraceCommand(command);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending delete deferred command failed");
            }
        }
    }

    @Override
    public void disableFilmstripMode() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.disableFilmstripMode();
        } else {
            ((LiveTarget)this.getTarget()).setRequestEnabled(LiveTargetGlobalState.FILMSTRIP_MODE, false);
        }
    }

    @Override
    public void disconnect() {
        ((LiveTarget)this.getTarget()).sendRestoreAllToDefault();
        this.getTarget().getConnection().closeConnection();
        for (TraceDataModel model : this.getTarget().getModels()) {
            model.setInputComplete();
        }
    }

    @Override
    public void enableFilmstripMode() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.enableFilmstripMode();
        } else {
            ((LiveTarget)this.getTarget()).setRequestEnabled(LiveTargetGlobalState.FILMSTRIP_MODE, true);
        }
    }

    @Override
    public void enableModifyStateMode(@NonNull ModifyStateInterceptorCommand feature) {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.enableModifyStateMode(feature);
        }
    }

    @Override
    public boolean isActive() {
        return ((LiveTarget)this.getTarget()).isConnectionActive();
    }

    @Override
    public boolean isFilmstripModeEnabled() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.isFilmstripModeEnabled() : false;
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public void pause(boolean currentProcess) {
        try {
            if (currentProcess) {
                LiveProcessTarget lpt = this.getLiveProcessTarget();
                if (lpt != null) {
                    lpt.sendPauseCommand();
                }
            } else {
                ((LiveTarget)this.getTarget()).sendPauseCommand();
            }
        }
        catch (IOException e) {
            CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Pause request failed");
        }
    }

    @Override
    public void resume() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.resume();
        }
    }

    @Override
    public void step() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            lpt.step();
        }
    }

    @Override
    protected @NonNull String abstractGetName() {
        LiveTarget liveTarget = (LiveTarget)this.getTarget();
        if (liveTarget.isConnectionActive()) {
            return NullUtils.formattedString((String)"%s> Capturing %s", (Object[])new Object[]{NullUtils.stringValueOf((long)this.traceNumber), liveTarget.getConnection().getConnectionName()});
        }
        return NullUtils.formattedString((String)"%s> Capture %s", (Object[])new Object[]{NullUtils.stringValueOf((long)this.traceNumber), liveTarget.getConnection().getConnectionName()});
    }

    @Override
    public @NonNull String getToolTipText() {
        return String.valueOf(super.getToolTipText()) + ", capture started " + DATE_FORMAT.format(this.timestamp);
    }

    @Override
    public void attachHost() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            try {
                lpt.setAttached(true);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending attach command failed");
            }
        }
    }

    @Override
    public void detachHost() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        if (lpt != null) {
            try {
                lpt.setAttached(false);
            }
            catch (IOException e) {
                CoreLogging.severeNoAssert((ICoreLoggingSource)this, (String)"Sending detach command failed");
            }
        }
    }

    @Override
    public boolean canAttachAndDetach() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null && lpt.canAttachAndDetach();
    }

    @Override
    public boolean isDetached() {
        LiveProcessTarget lpt = this.getLiveProcessTarget();
        return lpt != null ? lpt.isDetached() : true;
    }

    public static class ConnectionFailedException
    extends Exception {
        private static final long serialVersionUID = -2147074787588495569L;

        private ConnectionFailedException(@NonNull String message) {
            super(message);
        }

        @Override
        public @NonNull String getMessage() {
            return (String)NullUtils.neverNull((Object)super.getMessage());
        }
    }
}

