/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.targetconn;

import com.arm.mgd.core.target.io.ProcessConfig;
import com.arm.mgd.core.target.io.ProcessConfigPreset;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.SerializationUtils;
import com.arm.mgd.core.util.executors.NamedExecutors;
import com.arm.mgd.core.util.executors.NamedThreadFactory;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveConnectionSettings {
    private static final @NonNull String TARGET_ADDRESS_KEY = "TARGET_ADDR";
    private static final @NonNull String TARGET_PORT_KEY = "TARGET_PORT";
    private static final @NonNull Path PROCESS_CONFIG_FILENAME = (Path)NullUtils.neverNull((Object)new File("ProcessConfig-default").toPath());
    private static final @NonNull ExecutorService SETTINGS_SAVE_THREAD = NamedExecutors.cachedFiniteThreadPool((int)1, (long)5L, (TimeUnit)TimeUnit.SECONDS, (NamedThreadFactory)new NamedThreadFactory("LiveConnectionSettings Executor"));
    private static @NonNull String currentAddress = LiveConnectionSettings.initializeCurrentAddress();
    private static int currentPort = LiveConnectionSettings.initializePort();
    private static @NonNull ProcessConfig defaultProcessConfig = LiveConnectionSettings.initializeProcessConfig();

    private static @NonNull String initializeCurrentAddress() {
        String dialogSettingsAddress = Activator.getDefault().getDialogSettings().get(TARGET_ADDRESS_KEY);
        if (dialogSettingsAddress != null) {
            return dialogSettingsAddress;
        }
        return "127.0.0.1";
    }

    private static int initializePort() {
        try {
            return Activator.getDefault().getDialogSettings().getInt(TARGET_PORT_KEY);
        }
        catch (NumberFormatException numberFormatException) {
            return 5002;
        }
    }

    private static @NonNull ProcessConfig initializeProcessConfig() {
        try {
            byte @Nullable [] data = Activator.getDefault().getUserFileStore().load(PROCESS_CONFIG_FILENAME);
            if (data != null) {
                return (ProcessConfig)SerializationUtils.deserialize((byte[])data, (ClassLoader)ProcessConfig.class.getClassLoader());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            CoreLogging.severe(null, (Throwable)e, (String)("Failed to load the default process config from " + PROCESS_CONFIG_FILENAME));
        }
        return ProcessConfigPreset.LEGACY.getConfig();
    }

    public static synchronized @NonNull String getIPAddress() {
        return currentAddress;
    }

    public static synchronized int getPort() {
        return currentPort;
    }

    public static synchronized @NonNull ProcessConfig getDefaultProcessConfig() {
        return defaultProcessConfig;
    }

    public static synchronized void setCurrentPortAndAddress(@NonNull String address, int port) {
        currentAddress = address;
        currentPort = port;
        Activator.getDefault().getDialogSettings().put(TARGET_ADDRESS_KEY, address);
        Activator.getDefault().getDialogSettings().put(TARGET_PORT_KEY, port);
    }

    public static synchronized void setDefaultProcessConfig(@NonNull ProcessConfig config) {
        defaultProcessConfig = config;
        SETTINGS_SAVE_THREAD.execute(() -> {
            try {
                Activator.getDefault().getUserFileStore().store(PROCESS_CONFIG_FILENAME, SerializationUtils.serialize((Serializable)config));
            }
            catch (IOException e) {
                CoreLogging.severe(null, (Throwable)e, (String)("Failed to save the default process config to " + PROCESS_CONFIG_FILENAME));
            }
        });
    }
}

