/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.targetconn;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.FileTarget;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FileTargetConnection
extends AbstractTargetConnection {
    private static final NumberFormat MB_READ_FORMATTER = NumberFormat.getNumberInstance();

    static {
        MB_READ_FORMATTER.setGroupingUsed(true);
        MB_READ_FORMATTER.setMaximumFractionDigits(1);
        MB_READ_FORMATTER.setMinimumFractionDigits(1);
    }

    static @Nullable FileTargetConnection read(@NonNull File targetFile, @NonNull IProgressMonitor progressMonitor, long totalBytes, int nUnitsThisFile) throws IOException, ProtocolVersionException {
        FileTarget fileTarget = new FileTarget(targetFile);
        CoreLogging.info((ICoreLoggingSource)fileTarget, (String)("Reading trace data from " + targetFile.getAbsolutePath()));
        long nBytesThisFile = targetFile.length();
        String fileSizeStr = MB_READ_FORMATTER.format((float)nBytesThisFile / 1048576.0f);
        String baseTaskName = "Reading " + targetFile;
        int totalProgress = 0;
        long readStartTime = System.currentTimeMillis();
        fileTarget.asyncRead();
        while (!fileTarget.getConnection().isClosed()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long currentBytesRead = fileTarget.getConnection().getBytesRead();
            StringBuilder progress = new StringBuilder(baseTaskName);
            if (currentBytesRead > 0L) {
                String currentMB = MB_READ_FORMATTER.format((float)currentBytesRead / 1048576.0f);
                progress.append(" (").append(currentMB).append(" / ").append(fileSizeStr).append(" MB)");
            }
            int numCalls = fileTarget.getTotalFunctionCallCount();
            long elapsedMillis = System.currentTimeMillis() - readStartTime;
            int avgFcsPerSecond = (int)(1000.0 * (double)numCalls / (double)elapsedMillis);
            StringBuilder subProgress = new StringBuilder().append(numCalls).append(StringUtils.formatQuantity((long)numCalls, (String)" Function Call", (String)" Function Calls")).append(" processed");
            subProgress.append(" (").append(avgFcsPerSecond).append(" functions/s)");
            progressMonitor.setTaskName(progress.toString());
            progressMonitor.subTask(subProgress.toString());
            if (totalBytes != 0L) {
                int newProgress = (int)((float)nUnitsThisFile * (float)currentBytesRead / (float)nBytesThisFile);
                progressMonitor.worked(newProgress - totalProgress);
                totalProgress = newProgress;
            }
            if (!progressMonitor.isCanceled()) continue;
            fileTarget.getConnection().closeConnection();
            fileTarget.close(ICoreProgressMonitor.NULL_MONITOR);
            return null;
        }
        fileTarget.waitForProcessingToComplete();
        if (totalBytes != 0L) {
            progressMonitor.worked(nUnitsThisFile - totalProgress);
        }
        return new FileTargetConnection(fileTarget, targetFile);
    }

    private FileTargetConnection(@NonNull FileTarget target, @NonNull File targetFile) {
        super((AbstractTarget)target, targetFile);
    }

    @Override
    public boolean canCaptureFrame() {
        return false;
    }

    @Override
    public boolean canEnableModifyStateFeature(ModifyStateInterceptorCommand feature) {
        return false;
    }

    @Override
    public boolean canPause(boolean currentProcess) {
        return false;
    }

    @Override
    public boolean canResume() {
        return false;
    }

    @Override
    public void captureFrame() {
        CoreLogging.trace(null, (String)"FileTargetConnection.captureFrame() called");
    }

    @Override
    public void disableFilmstripMode() {
        CoreLogging.trace(null, (String)"FileTargetConnection.disableFilmstripMode() called");
    }

    @Override
    public void disconnect() {
    }

    @Override
    public void enableFilmstripMode() {
        CoreLogging.trace(null, (String)"FileTargetConnection.enableFilmstripMode() called");
    }

    @Override
    public void enableModifyStateMode(ModifyStateInterceptorCommand feature) {
        CoreLogging.trace(null, (String)"FileTargetConnection.enableModifyStateMode(feature) called");
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public boolean isFilmstripModeEnabled() {
        return false;
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public void pause(boolean currentProcess) {
        CoreLogging.trace(null, (String)"FileTargetConnection.pause(currentProcess) called");
    }

    @Override
    public void resume() {
        CoreLogging.trace(null, (String)"FileTargetConnection.resume() called");
    }

    @Override
    public void step() {
        CoreLogging.trace(null, (String)"FileTargetConnection.step() called");
    }

    @Override
    protected @NonNull String abstractGetName() {
        return ((FileTarget)this.getTarget()).getFileName();
    }

    @Override
    public void addAutomatedTraceCommand(AutomatedTraceCommand command) {
        CoreLogging.trace(null, (String)"FileTargetConnection.addDeferredCommand(command) called");
    }

    @Override
    public void deleteAutomatedTraceCommand(AutomatedTraceCommand command) {
        CoreLogging.trace(null, (String)"FileTargetConnection.deleteDeferredCommand(command) called");
    }

    @Override
    public void attachHost() {
        CoreLogging.trace(null, (String)"FileTargetConnection.attachHost() called");
    }

    @Override
    public void detachHost() {
        CoreLogging.trace(null, (String)"FileTargetConnection.detachHost() called");
    }

    @Override
    public boolean canAttachAndDetach() {
        return false;
    }

    @Override
    public boolean isDetached() {
        return false;
    }
}

