/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.targetconn;

import com.arm.mgd.core.target.data.AutomatedTraceCommand;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.AbstractTarget;
import com.arm.mgd.core.target.io.FileTarget;
import com.arm.mgd.core.target.io.FunctionCallWriter;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractTargetConnection
implements ICoreLoggingSource {
    private @Nullable File storageFile;
    private @NonNull AbstractTarget target;

    protected AbstractTargetConnection(@NonNull AbstractTarget target, @Nullable File storageFile) {
        this.target = target;
        this.storageFile = storageFile;
        assert (storageFile != null || !(target instanceof FileTarget)) : "If storageFile is null, target must be FileTarget";
    }

    public abstract boolean canCaptureFrame();

    public abstract boolean canEnableModifyStateFeature(@NonNull ModifyStateInterceptorCommand var1);

    public abstract boolean canPause(boolean var1);

    public abstract boolean canResume();

    public abstract void captureFrame();

    public abstract void addAutomatedTraceCommand(AutomatedTraceCommand var1);

    public abstract void deleteAutomatedTraceCommand(AutomatedTraceCommand var1);

    public abstract void disableFilmstripMode();

    public abstract void disconnect();

    public abstract void enableFilmstripMode();

    public abstract void enableModifyStateMode(@NonNull ModifyStateInterceptorCommand var1);

    public final @Nullable TraceDataModel getActiveModel() {
        return this.target.getActiveModel();
    }

    public final @NonNull String getName() {
        if (this.storageFile != null) {
            return (String)NullUtils.neverNull((Object)this.storageFile.getName());
        }
        return this.abstractGetName();
    }

    public final File getStorageFile() {
        return this.storageFile;
    }

    public final @NonNull AbstractTarget getTarget() {
        return this.target;
    }

    public String getTargetVersionLabel() {
        String versionString = this.target.getConnection().getUnmarshallerVersion();
        return versionString;
    }

    public @NonNull String getToolTipText() {
        String processName;
        TraceDataModel model = this.getActiveModel();
        String string = processName = model != null ? model.getProcessName() : null;
        if (processName == null) {
            processName = "<unknown>";
        }
        return (String)NullUtils.neverNull((Object)String.format("Process %s in %s, trace version %s", processName, this.getTarget().getConnection().getConnectionName(), this.getTargetVersionLabel()));
    }

    public abstract boolean isActive();

    public abstract boolean isFilmstripModeEnabled();

    public abstract boolean isLive();

    public abstract void pause(boolean var1);

    public abstract void resume();

    public void saveCurrentModelToFile(@NonNull IProgressMonitor progressMonitor, @NonNull File file) throws IOException {
        progressMonitor.beginTask("Saving trace to " + file, this.target.getTotalFunctionCallCount());
        try {
            FunctionCallWriter.write((File)file, (AbstractTarget)this.target, (ICoreProgressMonitor)new SimpleCoreProgressMonitor(progressMonitor));
        }
        finally {
            progressMonitor.done();
        }
        if (!progressMonitor.isCanceled()) {
            CoreLogging.info((ICoreLoggingSource)this.getActiveModel(), (String)("Trace saved to file " + file));
            this.storageFile = file;
        } else {
            CoreLogging.info((ICoreLoggingSource)this.getActiveModel(), (String)("Saving trace to " + file + " cancelled."));
        }
    }

    public abstract void step();

    protected abstract @NonNull String abstractGetName();

    public String getCoreLoggingSourceKey() {
        return this.target.getCoreLoggingSourceKey();
    }

    public void close(@NonNull ICoreProgressMonitor iCoreProgressMonitor) {
        this.target.close(iCoreProgressMonitor);
    }

    public abstract void attachHost();

    public abstract void detachHost();

    public abstract boolean canAttachAndDetach();

    public abstract boolean isDetached();
}

