/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.propertytesters;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.target.data.TraceDataModel;

public class OverridePropertyTester {
    public static boolean testTexture(TraceDataModel model, GlTextureAsset textureAsset, OverrideProperty property) {
        if (model != null && !model.isTheChildrenListFinal() && model.getParentProcessTarget().getParentTarget().isLiveTarget()) {
            assert (textureAsset != null);
            if (model.getCurrentActiveOverrides().contains(FrameOverrides.OverrideType.TEXTURE_OVERRIDE, (IAssetItem)textureAsset) ? property.equals((Object)OverrideProperty.REMOVE_TEXTURE) : property.equals((Object)OverrideProperty.ADD_TEXTURE)) {
                return true;
            }
        }
        return false;
    }

    public static boolean testForcePrecisionOverride(TraceDataModel model, GlProgramAsset program, OverrideProperty property) {
        if (model != null && !model.isTheChildrenListFinal() && model.getParentProcessTarget().getParentTarget().isLiveTarget()) {
            assert (program != null);
            if (model.getCurrentActiveOverrides().contains(FrameOverrides.OverrideType.FORCE_PRECISION_OVERRIDE, (IAssetItem)program) ? property.equals((Object)OverrideProperty.REMOVE_PRECISION) : property.equals((Object)OverrideProperty.ADD_PRECISION)) {
                return true;
            }
        }
        return false;
    }

    public static boolean testProgramOverride(TraceDataModel model, GlProgramAsset program, OverrideProperty property) {
        if (model != null && !model.isTheChildrenListFinal() && model.getParentProcessTarget().getParentTarget().isLiveTarget()) {
            assert (program != null);
            if (model.getCurrentActiveOverrides().contains(FrameOverrides.OverrideType.PROGRAM_OVERRIDE, (IAssetItem)program) ? property.equals((Object)OverrideProperty.REMOVE_PROGRAM) : property.equals((Object)OverrideProperty.ADD_PROGRAM)) {
                return true;
            }
        }
        return false;
    }

    public static enum OverrideProperty {
        ADD_TEXTURE,
        REMOVE_TEXTURE,
        ADD_PRECISION,
        REMOVE_PRECISION,
        ADD_PROGRAM,
        REMOVE_PROGRAM;

    }
}

