/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.propertytesters;

import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.IReplayableListener;
import com.arm.mgd.ui.propertytesters.AbstractPropertyTester;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;

public class FramePropertyTester
extends AbstractPropertyTester
implements IReplayableListener {
    private static final String IS_REPLAY_POSSIBLE_PROPERTY = "com.arm.mgd.ui.propertytesters.FrameReplayPropertyTester.isReplayPossible";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        AbstractTargetConnection currentConnection = TargetConnectionManager.getCurrentConnection();
        if (currentConnection == null) {
            return false;
        }
        if (!currentConnection.canResume()) {
            return false;
        }
        TraceDataModel model = currentConnection.getActiveModel();
        if (model == null) {
            return false;
        }
        if (model.hasEverBeenReattached() || model.processStartedBeforeTracing()) {
            return false;
        }
        Frame targetFrame = model.getFrames().getLatestFrame();
        assert (targetFrame != null);
        return targetFrame.isFrameReplayable((IReplayableListener)this);
    }

    public void onReplayStateUpdated(TraceDataModel model, Frame updatedFrame) {
        FramePropertyTester.requestRefresh(IS_REPLAY_POSSIBLE_PROPERTY);
    }
}

