/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.perspectives;

import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.dialogs.SwitchPerspectiveDialog;
import com.arm.mgd.ui.preferences.PreferenceConstant;
import java.util.Optional;
import javafx.util.Pair;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PerspectiveSwitcher
implements INavigationChangedListener {
    public static final @NonNull BuiltInPerspective DEFAULT_PERSPECTIVE = BuiltInPerspective.OPENGLESEGL;

    public void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getOldAndNewModels((oldModel, newModel) -> {
            if (oldModel != newModel && newModel != null) {
                PerspectiveSwitcher.switchPerspective(newModel);
            }
            return null;
        });
    }

    private static void switchPerspective(@NonNull TraceDataModel model) {
        IPreferenceStore preferenceStore = PreferenceConstant.getPreferenceStore();
        SwitchingBehaviour switchBehaviour = SwitchingBehaviour.valueOf(preferenceStore.getString(PreferenceConstant.AUTOMATED_PERSPECTIVE_SWITCHING.getPreferenceName()));
        if (switchBehaviour == SwitchingBehaviour.NEVER) {
            return;
        }
        @Nullable BuiltInPerspective perspectiveToSwitchTo = PerspectiveSwitcher.getPerspectiveToSwitchTo(model);
        Display.getDefault().asyncExec(() -> {
            boolean userWantsToSwitch;
            BuiltInPerspective currentPerspective = PerspectiveSwitcher.getCurrentPerspective();
            if (currentPerspective != null && perspectiveToSwitchTo != null && perspectiveToSwitchTo != currentPerspective && (userWantsToSwitch = switchBehaviour == SwitchingBehaviour.ALWAYS ? true : PerspectiveSwitcher.promptUser(perspectiveToSwitchTo))) {
                try {
                    PlatformUI.getWorkbench().showPerspective(perspectiveToSwitchTo.getId(), PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static boolean promptUser(BuiltInPerspective perspectiveToSwitchTo) {
        IPreferenceStore preferenceStore = PreferenceConstant.getPreferenceStore();
        SwitchPerspectiveDialog switchPerspectiveDialog = new SwitchPerspectiveDialog(perspectiveToSwitchTo.getName());
        Optional result = switchPerspectiveDialog.showAndWaitForResult();
        if (!result.isPresent()) {
            return false;
        }
        boolean userWantsToSwitch = (Boolean)((Pair)result.get()).getKey();
        if (((Boolean)((Pair)result.get()).getValue()).booleanValue()) {
            if (userWantsToSwitch) {
                preferenceStore.setValue(PreferenceConstant.AUTOMATED_PERSPECTIVE_SWITCHING.getPreferenceName(), SwitchingBehaviour.ALWAYS.name());
            } else {
                preferenceStore.setValue(PreferenceConstant.AUTOMATED_PERSPECTIVE_SWITCHING.getPreferenceName(), SwitchingBehaviour.NEVER.name());
            }
        }
        return userWantsToSwitch;
    }

    private static BuiltInPerspective getPerspectiveToSwitchTo(TraceDataModel newModel) {
        if (newModel.containsVULKAN()) {
            return BuiltInPerspective.VULKAN;
        }
        if (newModel.containsCL()) {
            return BuiltInPerspective.OPENCL;
        }
        if (newModel.containsGLES() || newModel.containsEGL()) {
            return BuiltInPerspective.OPENGLESEGL;
        }
        return null;
    }

    private static @Nullable BuiltInPerspective getCurrentPerspective() {
        return BuiltInPerspective.fromId(PerspectiveSwitcher.getCurrentPerspectiveID());
    }

    private static @Nullable String getCurrentPerspectiveID() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IPerspectiveDescriptor perspective = page.getPerspective();
        return perspective.getId();
    }

    public static enum BuiltInPerspective {
        VULKAN("com.arm.mgd.ui.vulkanperspective", "Vulkan Perspective"),
        OPENCL("com.arm.mgd.ui.openclperspective", "OpenCL Perspective"),
        OPENGLESEGL("com.arm.mgd.ui.opengleseglperspective", "OpenGL ES and EGL Perspective");

        private final @NonNull String id;
        private final @NonNull String name;

        private BuiltInPerspective(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public @NonNull String getId() {
            return this.id;
        }

        static @Nullable BuiltInPerspective fromId(@Nullable String id) {
            BuiltInPerspective[] builtInPerspectiveArray = BuiltInPerspective.values();
            int n = builtInPerspectiveArray.length;
            int n2 = 0;
            while (n2 < n) {
                BuiltInPerspective perspective = builtInPerspectiveArray[n2];
                if (perspective.getId().equals(id)) {
                    return perspective;
                }
                ++n2;
            }
            return null;
        }

        public @NonNull String getName() {
            return this.name;
        }
    }

    public static enum SwitchingBehaviour {
        PROMPT,
        ALWAYS,
        NEVER;

    }
}

