/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.LiveTargetGlobalState;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.ui.handlers.AbstractToggleHandler;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ToggleFilmstripModeHandler
extends AbstractToggleHandler {
    @Override
    public void disableFeature() {
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        if (connection != null) {
            connection.disableFilmstripMode();
        }
    }

    @Override
    public void enableFeature() {
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        if (connection != null) {
            connection.enableFilmstripMode();
        }
    }

    public boolean isEnabled() {
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        if (connection == null || !connection.isActive()) {
            return false;
        }
        TraceDataModel model = connection.getActiveModel();
        if (model == null) {
            return true;
        }
        return !model.containsOnlyCL() && !model.containsVULKAN();
    }

    @Override
    public void onInterceptorStateChanged(@NonNull InterceptorExecutionState oldState, @NonNull InterceptorExecutionState newState, int processID) {
        super.onInterceptorStateChanged(oldState, newState, processID);
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        this.updateState(ToggleFilmstripModeHandler.isPushed(connection));
    }

    @Override
    public void onTargetModifyStateChanged(ModifyStateInterceptorCommand newState) {
        super.onTargetModifyStateChanged(newState);
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        this.updateState(ToggleFilmstripModeHandler.isPushed(connection));
    }

    @Override
    public void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        super.onNavigationChanged(navigationUriChangeEvent);
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        this.updateState(ToggleFilmstripModeHandler.isPushed(connection));
    }

    private static boolean isPushed(@Nullable AbstractTargetConnection connection) {
        if (connection == null) {
            return false;
        }
        boolean defaultValue = (Boolean)LiveTargetGlobalState.FILMSTRIP_MODE.defaultValue;
        boolean isLiveTarget = connection.getTarget().isLiveTarget();
        boolean isConnectionActive = isLiveTarget ? ((LiveTarget)connection.getTarget()).isConnectionActive() : false;
        return isConnectionActive ? connection.isFilmstripModeEnabled() : defaultValue;
    }
}

