/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.ui.DialogFileTypes;
import com.arm.mgd.ui.UIHandler;
import com.arm.mgd.ui.editorinput.TargetEditorInput;
import com.arm.mgd.ui.targetconn.FileTargetConnection;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenTraceFileHandler
extends AbstractHandler {
    private static final String LAST_OPEN_TRACE_FILE_LOCATION_IDENTIFIER = "lastOpenTraceFileLocation";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        Shell shell = window.getShell();
        FileDialog dialog = DialogFileTypes.OPEN_TRACE.createDialog(shell);
        String lastOpenTraceFileLocation = PlatformUI.getPreferenceStore().getString(LAST_OPEN_TRACE_FILE_LOCATION_IDENTIFIER);
        if (lastOpenTraceFileLocation != null && !lastOpenTraceFileLocation.isEmpty()) {
            dialog.setFilterPath(lastOpenTraceFileLocation);
        }
        shell.setEnabled(false);
        String firstSelectedPath = dialog.open();
        shell.setEnabled(true);
        if (firstSelectedPath != null) {
            File firstSelectedFile = new File(firstSelectedPath);
            String basePath = firstSelectedFile.getParent();
            String[] selectedFiles = dialog.getFileNames();
            PlatformUI.getPreferenceStore().setValue(LAST_OPEN_TRACE_FILE_LOCATION_IDENTIFIER, basePath);
            ArrayList<File> filesToOpen = new ArrayList<File>(selectedFiles.length);
            String[] stringArray = selectedFiles;
            int n = selectedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                File f = new File(basePath, filename);
                if (!firstSelectedFile.exists()) {
                    UIHandler.warningMessage("Failed to open trace", "Cannot open '" + f + "': file does not exist.");
                } else {
                    filesToOpen.add(f);
                }
                ++n2;
            }
            OpenTraceFileHandler.openFiles(window, filesToOpen);
        }
        return null;
    }

    public static Job openFiles(final IWorkbenchWindow window, final List<File> filesToOpen) {
        assert (window != null);
        assert (filesToOpen != null);
        final long totalBytes = OpenTraceFileHandler.getTotalBytesToRead(filesToOpen);
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        String totalBytesLabel = decimalFormat.format(Float.valueOf((float)totalBytes / 1048576.0f));
        Job job = new Job("Reading " + totalBytesLabel + " MB from " + filesToOpen.size() + " trace file(s)"){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void openEditor(IProgressMonitor monitor, File inputFile, FileTargetConnection targetConnection) {
                if (targetConnection.getTarget().getTotalFunctionCallCount() > 0) {
                    monitor.setTaskName("Opening editor on " + inputFile.getName());
                    CoreInstance.getNavigationManager().addTarget(targetConnection.getTarget());
                    TargetEditorInput.openEditor(window, targetConnection);
                }
                targetConnection.getTarget().forEachProcessTarget(processTarget -> {
                    TraceDataModel model = processTarget.getModel();
                    CoreLogging.info((ICoreLoggingSource)model, (String)("Found " + model.count() + " API calls in " + model.getFrames().count() + " frames"));
                });
            }
        };
        job.setUser(true);
        job.schedule();
        return job;
    }

    private static long getTotalBytesToRead(List<File> filesToOpen) {
        long nb = 0L;
        for (File inputFile : filesToOpen) {
            nb += inputFile.length();
        }
        return nb;
    }
}

