/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.ClKernelAsset;
import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.SynchronousTraceStateSnapshot;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.FileUtils;
import com.arm.mgd.core.util.GpuVerify;
import com.arm.mgd.ui.dialogs.LaunchGpuVerifyDialog;
import com.arm.mgd.ui.preferences.PreferenceConstant;
import com.arm.mgd.utils.NullUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchGpuVerifyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        LaunchGpuVerifyHandler.launchGpuVerifyJob(window);
        return null;
    }

    private static void launchGpuVerify(IWorkbenchWindow window) {
        IPreferenceStore preferenceStore = PreferenceConstant.getPreferenceStore();
        String gpuVerifyLocation = preferenceStore.getString(PreferenceConstant.LOCATION_OF_GPUVERIFY.getPreferenceName());
        if (gpuVerifyLocation.equals("")) {
            CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"GPUVerify can't be started until its location has been given in the Preferences window. Please supply this information before continuing.\n\nFor more information about GPUVerify, visit its home page at\nhttp://multicore.doc.ic.ac.uk/tools/GPUVerify/");
            return;
        }
        @Nullable FunctionCall functionCall = CoreInstance.getNavigationManager().getActiveFunctionCall();
        if (functionCall == null) {
            CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"No process selected.");
            return;
        }
        SynchronousTraceStateSnapshot snapshot = new SynchronousTraceStateSnapshot(functionCall.getModel());
        snapshot.setSelectedFunction(functionCall.getIndex());
        AssetTable kernelAssetTable = snapshot.getAssetTableBySpec(KapiSpec.CL.assetTables.KERNEL_TRAITS.SPEC);
        if (kernelAssetTable.isEmpty()) {
            CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"No live kernel objects at the currently selected function call.");
            return;
        }
        ArrayList<@NonNull LaunchGpuVerifyDialog.KernelSourcePair> kernelAssets = new ArrayList<LaunchGpuVerifyDialog.KernelSourcePair>();
        for (IAssetItem asset : kernelAssetTable) {
            assert (asset instanceof ClKernelAsset);
            ClKernelAsset kernelAsset = (ClKernelAsset)asset;
            String source = kernelAsset.getProgramAsset().getSource();
            if (source == null) continue;
            kernelAssets.add(new LaunchGpuVerifyDialog.KernelSourcePair((ClKernelAsset)asset, source));
        }
        if (kernelAssets.isEmpty()) {
            CoreLogging.userMessage(null, (Level)Level.WARNING, (String)"No source code available for any of the kernel objects at the current selected function call. Only kernels that have been created from a program that was created using clCreateProgramWithSource followed by clBuildProgram have the full source code available.");
            return;
        }
        Display.getDefault().asyncExec(() -> {
            block3: {
                LaunchGpuVerifyDialog dlg = new LaunchGpuVerifyDialog(window.getShell(), kernelAssets);
                if (dlg.open() == 0) {
                    try {
                        @NonNull LaunchGpuVerifyDialog.KernelSourcePair kernelSourcePair = dlg.getSelectedAsset();
                        @NonNull ClKernelAsset clKernel = kernelSourcePair.kernelAsset;
                        @NonNull String kernelBuildOptions = dlg.getKernelBuildOptions();
                        @NonNull ComputeWorkgroupSize lLocalSize = dlg.getLocalSize();
                        @NonNull ComputeWorkgroupSize lGlobalSize = dlg.getGlobalSize();
                        File kernelSourceFile = FileUtils.createTempFile((String)clKernel.getId().toString(), (String)".cl");
                        @NonNull String sourcePath = (String)NullUtils.neverNull((Object)kernelSourceFile.getAbsolutePath());
                        FileWriter fileWriter = new FileWriter(sourcePath);
                        BufferedWriter bw = new BufferedWriter(fileWriter);
                        bw.write(kernelSourcePair.source);
                        bw.close();
                        GpuVerify.GpuVerifyCommand newCommand = new GpuVerify.GpuVerifyCommand(sourcePath, lLocalSize, lGlobalSize, clKernel.getKernelName(), kernelBuildOptions);
                        LaunchGpuVerifyHandler.runGpuVerifyJob(clKernel.getId(), gpuVerifyLocation, newCommand);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError();
                    }
                }
            }
        });
    }

    private static void launchGpuVerifyJob(final IWorkbenchWindow window) {
        Job job = new Job("Launching GPUVerify Dialog"){

            protected IStatus run(IProgressMonitor monitor) {
                LaunchGpuVerifyHandler.launchGpuVerify(window);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static void runGpuVerifyJob(final @NonNull Long clKernel, final @NonNull String gpuVerifyLocation, final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull GpuVerify.GpuVerifyCommand newCommand) {
        Job job = new Job("Running GPUVerify"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    GpuVerify.launchGpuVerify((Long)clKernel, (String)gpuVerifyLocation, (GpuVerify.GpuVerifyCommand)newCommand);
                }
                catch (IOException e) {
                    CoreLogging.severe((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

