/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.ui.dialogs.CopyableMessageDialog;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;

public class FrameReplayHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String captureId = "com.arm.mgd.ui.commands.frameReplayWithCapture";
        boolean NO = false;
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        if (connection != null && connection.isLive()) {
            CopyableMessageDialog dialog;
            TraceDataModel currentModel = connection.getActiveModel();
            LiveTarget currentTarget = (LiveTarget)connection.getTarget();
            assert (currentModel != null);
            assert (currentTarget != null);
            if (currentModel.getCurrentActiveOverrides().areOverridesDirty() && (dialog = new CopyableMessageDialog(null, 3, "Currently there are unsaved changes to at least 1 frame override. Do you still want to proceed?", new String[]{"No", "Yes"}, new String[2])).open() == 0) {
                return null;
            }
            FrameReplayHandler.dispatchReplayFrameJob(currentModel, "com.arm.mgd.ui.commands.frameReplayWithCapture".equals(event.getCommand().getId()));
        }
        return null;
    }

    private static void dispatchReplayFrameJob(final @NonNull TraceDataModel currentModel, final boolean capture) {
        Job job = new Job(capture ? "Replay frame (with capture)" : "Replay frame"){

            protected IStatus run(IProgressMonitor monitor) {
                currentModel.getFrames().getLatestFrame().replayFrame(capture, currentModel.getCurrentActiveOverrides(), (ICoreProgressMonitor)new SimpleCoreProgressMonitor(monitor), SendingReplayCommandsProgressMonitor.create(monitor));
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static class SendingReplayCommandsProgressMonitor
    extends SimpleCoreProgressMonitor {
        private static final int PROGRESS_MONITOR_UPDATE_PERIOD_NANOSECONDS = 40000000;
        private final IProgressMonitor monitor;
        private int accumulatedWork;
        private long lastProgressMonitorUpdateInNanoSeconds;

        public static ICoreProgressMonitor create(IProgressMonitor monitor) {
            return new SendingReplayCommandsProgressMonitor(monitor);
        }

        private SendingReplayCommandsProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
            this.monitor = monitor;
            this.accumulatedWork = 0;
            this.lastProgressMonitorUpdateInNanoSeconds = System.nanoTime();
        }

        @Override
        public void incProgress(int n) {
            ++this.accumulatedWork;
            long nowInNanoSeconds = System.nanoTime();
            if (nowInNanoSeconds - this.lastProgressMonitorUpdateInNanoSeconds >= 40000000L) {
                this.monitor.worked(this.accumulatedWork);
                this.accumulatedWork = 0;
                this.lastProgressMonitorUpdateInNanoSeconds = nowInNanoSeconds;
            }
        }

        public void finished() {
            if (this.accumulatedWork > 0) {
                this.monitor.worked(this.accumulatedWork);
                this.accumulatedWork = 0;
                this.lastProgressMonitorUpdateInNanoSeconds = System.nanoTime();
            }
        }
    }
}

