/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.target.data.Frame;
import com.arm.mgd.core.target.data.Frames;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.LiveProcessTarget;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.live.InterceptorCaptureState;
import com.arm.mgd.ui.controllers.CaptureModeController;
import com.arm.mgd.ui.handlers.AbstractInterceptorStateHandler;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import java.util.ListIterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class FrameCaptureHandler
extends AbstractInterceptorStateHandler {
    IProgressMonitor currentMonitor;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        if (connection != null) {
            connection.enableModifyStateMode(CaptureModeController.getCaptureMode());
            connection.captureFrame();
        }
        return null;
    }

    public boolean isEnabled() {
        boolean containsOnlyCL;
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        TraceDataModel model = connection == null ? null : connection.getActiveModel();
        boolean bl = containsOnlyCL = model == null ? false : model.containsOnlyCL();
        return this.currentMonitor == null && connection != null && connection instanceof LiveTargetConnection && connection.canCaptureFrame() && model != null && !containsOnlyCL;
    }

    @Override
    public void onInterceptorCaptureStateChanged(@NonNull InterceptorCaptureState oldState, @NonNull InterceptorCaptureState newState) {
        TraceDataModel currentModel;
        super.onInterceptorCaptureStateChanged(oldState, newState);
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        if (connection != null && connection.isLive() && (currentModel = connection.getActiveModel()) != null) {
            if (newState == InterceptorCaptureState.CAPTURE_PENDING) {
                this.showCapturingProgress(currentModel);
            }
            if (newState == InterceptorCaptureState.CAPTURING_FRAME && this.currentMonitor != null) {
                Frames frames = currentModel.getFrames();
                int previousFrameNumberOfInterestingCalls = -1;
                if (frames.count() >= 2) {
                    Frame lastCompleteFrame = FrameCaptureHandler.getLastCompleteFrame(frames);
                    previousFrameNumberOfInterestingCalls = lastCompleteFrame.getInterestingCallCount() + 1;
                }
                this.currentMonitor.beginTask("Capturing frame", previousFrameNumberOfInterestingCalls);
            }
        }
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    private static Frame getLastCompleteFrame(Frames frames) {
        assert (!frames.getFrames().isEmpty());
        ListIterator<@NonNull E> listIterator = frames.getFrames().listIterator(frames.getFrames().size());
        while (listIterator.hasPrevious()) {
            Frame frame = (Frame)listIterator.previous();
            if (!frame.isTheChildrenListFinal()) continue;
            return frame;
        }
        return frames.getLatestFrame();
    }

    private void showCapturingProgress(final @NonNull TraceDataModel currentModel) {
        assert (currentModel != null);
        Job job = new Job("Capturing frame"){

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    block13: {
                        int previousNumberOfInterestingCallsForCurrentFrame;
                        Frame frameBeingCaptured;
                        Frames frames;
                        LiveTarget liveTarget;
                        LiveProcessTarget processTarget;
                        block12: {
                            processTarget = (LiveProcessTarget)currentModel.getParentProcessTarget();
                            liveTarget = (LiveTarget)processTarget.getParentTarget();
                            frames = currentModel.getFrames();
                            frameBeingCaptured = null;
                            FrameCaptureHandler.this.currentMonitor = monitor;
                            monitor.beginTask("Waiting for next frame", -1);
                            previousNumberOfInterestingCallsForCurrentFrame = 0;
                            if (!true) break block12;
                            if (!liveTarget.isConnectionActive()) return Status.OK_STATUS;
                            if (!processTarget.isWaitingOrCapturingFrame()) return Status.OK_STATUS;
                            if (!processTarget.isProcessConnectionActive()) break block13;
                        }
                        do {
                            if (processTarget.isCapturingFrame()) {
                                Frame latestFrame = frames.getLatestFrame();
                                if (latestFrame != frameBeingCaptured) {
                                    frameBeingCaptured = latestFrame;
                                    previousNumberOfInterestingCallsForCurrentFrame = 0;
                                }
                                if (latestFrame != null && !latestFrame.isTheChildrenListFinal()) {
                                    int currentNumberOfInterestingCalls = latestFrame.getInterestingCallCount();
                                    int difference = currentNumberOfInterestingCalls - previousNumberOfInterestingCallsForCurrentFrame;
                                    previousNumberOfInterestingCallsForCurrentFrame = currentNumberOfInterestingCalls;
                                    monitor.worked(difference);
                                    StringBuilder sb = new StringBuilder();
                                    int numAsyncData = 0;
                                    @Nullable Integer asyncUid = currentModel.getMostRecentCallItem().getAsynchronousFunctionCallUid();
                                    if (asyncUid != null) {
                                        numAsyncData = currentModel.getAsynchronousDataModel().getAsynchronousAssetData(asyncUid).size();
                                    }
                                    sb.append("Capturing Frame (Calls Processed: ").append(latestFrame.getApiCallCount());
                                    if (numAsyncData != 0) {
                                        sb.append(", Call Data Items Received: ").append(numAsyncData);
                                    }
                                    sb.append(")");
                                    monitor.setTaskName(sb.toString());
                                }
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (!liveTarget.isConnectionActive()) return Status.OK_STATUS;
                            if (!processTarget.isWaitingOrCapturingFrame()) return Status.OK_STATUS;
                        } while (processTarget.isProcessConnectionActive());
                    }
                    return Status.OK_STATUS;
                }
                finally {
                    monitor.done();
                    FrameCaptureHandler.this.currentMonitor = null;
                    FrameCaptureHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)FrameCaptureHandler.this, true, false));
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }
}

