/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.NavigationUri;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.TraceWriter;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.DialogFileTypes;
import com.arm.mgd.ui.handlers.AbstractInterceptorStateHandler;
import com.arm.mgd.ui.utils.FileDialogHelper;
import java.io.File;
import java.io.PrintWriter;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.PlatformUI;

public class ExportTraceHandler
extends AbstractInterceptorStateHandler {
    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        NavigationUri uri = CoreInstance.getNavigationManager().getActiveNavigationUri();
        if (uri != null) {
            uri.getModel(model -> {
                File selectedFile;
                if (model != null && (selectedFile = FileDialogHelper.promptForFile(DialogFileTypes.EXPORT_TRACE, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), true, null)) != null) {
                    try (PrintWriter sOut = null;){
                        try {
                            sOut = new PrintWriter(selectedFile);
                            TraceWriter.write((TraceDataModel)model, (PrintWriter)sOut);
                        }
                        catch (Exception e) {
                            CoreLogging.severe(null, (String)("Unable to Export " + e.getLocalizedMessage()));
                            if (sOut != null) {
                                sOut.close();
                            }
                        }
                    }
                }
                return null;
            });
        }
        return null;
    }

    public boolean isEnabled() {
        return CoreInstance.getNavigationManager().getActiveNavigationUri() != null;
    }
}

