/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.authorisation.ApplicationFeatureAuthoriser;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.ui.handlers.AbstractInterceptorStateHandler;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.FileDialogHelper;
import com.arm.mgd.ui.utils.GUIExporterController;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportAllCapturedFramebuffersHandler
extends AbstractInterceptorStateHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        File selectedDir = FileDialogHelper.promptForDirectory(null);
        if (selectedDir != null) {
            HashMap<@NonNull TraceDataModel, Set<Integer>> modelToDrawCallMap = new HashMap<TraceDataModel, Set<Integer>>();
            AbstractTargetConnection currentConnection = TargetConnectionManager.getCurrentConnection();
            if (currentConnection == null) {
                return null;
            }
            for (TraceDataModel model : currentConnection.getTarget().getModels()) {
                modelToDrawCallMap.put(model, null);
            }
            Job j = GUIExporterController.exportCapturedFramebuffers(modelToDrawCallMap, selectedDir);
            FileDialogHelper.openFileAfterJobComplete(j, selectedDir);
        }
        return null;
    }

    public boolean isEnabled() {
        if (!ApplicationFeatureAuthoriser.RESOURCES_EXPORT.isAuthorisationReceivedAndApproved()) {
            return false;
        }
        @Nullable AbstractTargetConnection currentConnection = TargetConnectionManager.getCurrentConnection();
        if (currentConnection == null) {
            return false;
        }
        @Nullable TraceDataModel activeModel = currentConnection.getActiveModel();
        return activeModel != null && activeModel.containsGLES();
    }
}

