/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.ui.handlers.AbstractInterceptorStateHandler;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class DisconnectTargetHandler
extends AbstractInterceptorStateHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DisconnectTargetHandler.disconnectTarget();
        return null;
    }

    public static void disconnectTarget() {
        final AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                if (connection != null) {
                    SimpleCoreProgressMonitor coreMonitor = new SimpleCoreProgressMonitor(monitor);
                    coreMonitor.setTask("Disconnecting from device", 100);
                    connection.disconnect();
                    coreMonitor.incProgress(50);
                    TargetConnectionManager.releaseConnection(connection, coreMonitor);
                }
                monitor.done();
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            CoreLogging.severe((ICoreLoggingSource)connection, (Throwable)e, null);
        }
    }

    public boolean isEnabled() {
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        return connection != null && connection.isActive();
    }
}

