/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.adb.ADBDevice;
import com.arm.mgd.core.adb.AndroidBridge;
import com.arm.mgd.core.adb.IADBTask;
import com.arm.mgd.core.adb.IAndroidPackageTraceManager;
import com.arm.mgd.core.authorisation.FeatureAuthorisation;
import com.arm.mgd.core.target.io.LiveTarget;
import com.arm.mgd.core.target.io.connection.ProtocolVersionException;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreProgressMonitor;
import com.arm.mgd.ui.dialogs.CopyableMessageDialog;
import com.arm.mgd.ui.dialogs.DeviceManager;
import com.arm.mgd.ui.dialogs.LicenseFeatureNotAvailableDialog;
import com.arm.mgd.ui.editorinput.TargetEditorInput;
import com.arm.mgd.ui.handlers.AbstractInterceptorStateHandler;
import com.arm.mgd.ui.targetconn.LiveTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConnectTargetHandler
extends AbstractInterceptorStateHandler {
    private static final @NonNull AtomicReference<@Nullable ConnectionInputs> lastSuccessfulConnection = new AtomicReference<Object>(null);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final @Nullable ConnectionInputs inputs = lastSuccessfulConnection.get();
        if (inputs != null) {
            final IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell());
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Reconnecting last successful connection", 100);
                        @Nullable AndroidBridge bridge = inputs.getAndroidBridge();
                        if (bridge != null) {
                            try {
                                @Nullable IAndroidPackageTraceManager traceManager = inputs.getTraceManager();
                                if (!$assertionsDisabled && traceManager == null) {
                                    throw new AssertionError();
                                }
                                SimpleCoreProgressMonitor coreMonitor = new SimpleCoreProgressMonitor(monitor);
                                traceManager.setProgressMonitor((ICoreProgressMonitor)coreMonitor);
                                @Nullable ADBDevice device = inputs.getAdbDevice();
                                if (!$assertionsDisabled && device == null) {
                                    throw new AssertionError();
                                }
                                TargetConnectionManager.cleanupPastConnectionToADBDevice(device, coreMonitor);
                                try {
                                    bridge.connectToDevice((ADBDevice)NullUtils.neverNull((Object)device), (ip, port) -> ConnectTargetHandler.connectAndKillRunningDaemon(ip, port, device)).run(traceManager.getExecutor());
                                    bridge.installAPILayerToApp((IAndroidPackageTraceManager)NullUtils.neverNull((Object)inputs.getTraceManager())).run(traceManager.getExecutor());
                                }
                                catch (IADBTask.ADBException e) {
                                    throw new ProtocolVersionException("An older version of the GA Daemon is already running on the device. Please kill the daemon process and try again");
                                }
                                coreMonitor.setTask("Connecting to the device", 1);
                                bridge.connectToDevice((ADBDevice)NullUtils.neverNull((Object)inputs.getAdbDevice()), (ip, port) -> {
                                    LiveTargetConnection connection = ConnectTargetHandler.doConnectTargetSynchronous(ip, port, inputs.getAdbDevice(), inputs.getTraceManager(), inputs.getAndroidBridge(), window);
                                    coreMonitor.incProgress(1);
                                    return connection != null;
                                }).run(traceManager.getExecutor());
                                bridge.startTracedPackage((IAndroidPackageTraceManager)NullUtils.neverNull((Object)inputs.getTraceManager())).run(traceManager.getExecutor());
                            }
                            catch (IADBTask.ADBException | ProtocolVersionException e) {
                                CoreLogging.severe((Throwable)e);
                            }
                        } else {
                            ConnectTargetHandler.doConnectTargetSynchronous(inputs.getTargetIP(), inputs.getTargetPort(), inputs.getAdbDevice(), inputs.getTraceManager(), inputs.getAndroidBridge(), window, true);
                        }
                        monitor.done();
                    }
                };
                try {
                    dialog.run(true, false, runnable);
                }
                catch (InterruptedException | InvocationTargetException e) {
                    CoreLogging.severe((Throwable)e);
                }
            }
        } else {
            new DeviceManager().showAndWait();
        }
        return null;
    }

    public static @Nullable LiveTargetConnection doConnectTargetSynchronous(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice, @Nullable IAndroidPackageTraceManager traceManager, @Nullable AndroidBridge androidBridge, @NonNull IWorkbenchWindow editorWindow) {
        return ConnectTargetHandler.doConnectTargetSynchronous(targetIP, targetPort, adbDevice, traceManager, androidBridge, editorWindow, false);
    }

    private static @Nullable LiveTargetConnection doConnectTargetSynchronous(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice, @Nullable IAndroidPackageTraceManager traceManager, @Nullable AndroidBridge androidBridge, @NonNull IWorkbenchWindow editorWindow, boolean usedHandler) {
        LiveTargetConnection connection;
        block11: {
            connection = null;
            try {
                assert (!Platform.isFxApplicationThread());
                try {
                    connection = TargetConnectionManager.createLiveConnection(targetIP, targetPort, adbDevice, traceManager);
                }
                catch (LiveTargetConnection.ConnectionFailedException e) {
                    ConnectTargetHandler.showConnectionErrorDialog(e, usedHandler);
                    return null;
                }
            }
            catch (Exception e) {
                if (connection != null) {
                    TargetConnectionManager.releaseConnection(connection, ICoreProgressMonitor.NULL_MONITOR);
                }
                throw e;
            }
            boolean isFeatureAuthorised = false;
            try {
                FeatureAuthorisation connectionAuthorisation = (FeatureAuthorisation)connection.getTarget().isAuthorised().get();
                isFeatureAuthorised = connectionAuthorisation.isAuthorised();
                if (!isFeatureAuthorised) {
                    Platform.runLater(() -> LicenseFeatureNotAvailableDialog.show(connectionAuthorisation.getFeature(), connectionAuthorisation.getReason()));
                }
            }
            catch (InterruptedException | java.util.concurrent.ExecutionException e) {
                CoreLogging.info(null, (Throwable)e, (String)e.getMessage());
            }
            if (isFeatureAuthorised) break block11;
            TargetConnectionManager.releaseConnection(connection, ICoreProgressMonitor.NULL_MONITOR);
            connection.disconnect();
            connection.close(ICoreProgressMonitor.NULL_MONITOR);
            return null;
        }
        TargetEditorInput.openEditor(editorWindow, connection);
        CoreInstance.getNavigationManager().addTarget(connection.getTarget());
        lastSuccessfulConnection.set(new ConnectionInputs(targetIP, targetPort, adbDevice, traceManager, androidBridge));
        return connection;
    }

    public static @Nullable LiveTargetConnection getLiveConnectionToDaemon(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice) {
        @Nullable LiveTargetConnection connection = null;
        assert (!Platform.isFxApplicationThread());
        try {
            connection = TargetConnectionManager.getLiveConnectionToDaemon(targetIP, targetPort, adbDevice);
        }
        catch (LiveTargetConnection.ConnectionFailedException e) {
            return null;
        }
        return connection;
    }

    public boolean isEnabled() {
        @Nullable ConnectionInputs inputs = lastSuccessfulConnection.get();
        if (inputs != null) {
            @Nullable ADBDevice device = inputs.getAdbDevice();
            if (device == null) {
                InetSocketAddress address = new InetSocketAddress(inputs.getTargetIP(), inputs.getTargetPort());
                return TargetConnectionManager.getLiveConnectionToAddress(address) == null;
            }
            return TargetConnectionManager.getLiveConnectionToADBDevice(device) == null;
        }
        return true;
    }

    private static void showConnectionErrorDialog(@NonNull LiveTargetConnection.ConnectionFailedException exception, final boolean usedHandler) {
        final String message = exception.getMessage();
        CoreLogging.info(null, (String)message);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (usedHandler) {
                    String[] stringArray = new String[2];
                    stringArray[1] = "com.arm.mgd.ui.commands.deviceManager";
                    new CopyableMessageDialog("Error", 1, message, new String[]{"OK", "Open the Device Manager"}, stringArray).open();
                } else {
                    new CopyableMessageDialog("Error", 1, message, new String[]{"OK"}, new String[1]).open();
                }
            }
        });
    }

    public static boolean connectAndKillRunningDaemon(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice) {
        LiveTargetConnection connection = ConnectTargetHandler.getLiveConnectionToDaemon(targetIP, targetPort, adbDevice);
        if (connection != null) {
            try {
                LiveTarget target = (LiveTarget)connection.getTarget();
                if (target.killDaemonAndCloseConnection()) {
                    return true;
                }
            }
            catch (IOException daemonConnectionException) {
                CoreLogging.severe(null, (String)daemonConnectionException.getMessage());
            }
            return false;
        }
        return true;
    }

    private static class ConnectionInputs {
        private final @NonNull String targetIP;
        private final int targetPort;
        private final @Nullable ADBDevice adbDevice;
        private final @Nullable IAndroidPackageTraceManager traceManager;
        private final @Nullable AndroidBridge androidBridge;

        private ConnectionInputs(@NonNull String targetIP, int targetPort, @Nullable ADBDevice adbDevice, @Nullable IAndroidPackageTraceManager traceManager, @Nullable AndroidBridge androidBridge) {
            this.targetIP = targetIP;
            this.targetPort = targetPort;
            this.adbDevice = adbDevice;
            this.traceManager = traceManager;
            this.androidBridge = androidBridge;
        }

        public @NonNull String getTargetIP() {
            return this.targetIP;
        }

        public int getTargetPort() {
            return this.targetPort;
        }

        public @Nullable ADBDevice getAdbDevice() {
            return this.adbDevice;
        }

        public @Nullable IAndroidPackageTraceManager getTraceManager() {
            return this.traceManager;
        }

        public @Nullable AndroidBridge getAndroidBridge() {
            return this.androidBridge;
        }
    }
}

