/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.ui.controllers.CaptureModeController;
import com.arm.mgd.ui.handlers.AbstractToggleHandler;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractToggleModifyStateInterceptorStateHandler
extends AbstractToggleHandler {
    public AbstractToggleModifyStateInterceptorStateHandler() {
        CaptureModeController.addCaptureModeEnabledListener(captureMode -> {
            if (captureMode != this.getFeature()) {
                this.disableFeature();
                this.updateState(false);
            }
        });
    }

    public boolean isEnabled() {
        AbstractTargetConnection connection = TargetConnectionManager.getCurrentConnection();
        return connection != null && connection.canEnableModifyStateFeature(this.getFeature());
    }

    @Override
    public void onTargetModifyStateChanged(ModifyStateInterceptorCommand newState) {
        super.onTargetModifyStateChanged(newState);
        this.updateState(newState == this.getFeature());
    }

    @Override
    public void enableFeature() {
        CaptureModeController.setCaptureMode(this.getFeature(), true);
    }

    @Override
    public void disableFeature() {
        CaptureModeController.setCaptureMode(this.getFeature(), false);
    }

    public abstract @NonNull ModifyStateInterceptorCommand getFeature();
}

