/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.handlers;

import com.arm.mgd.core.CoreInstance;
import com.arm.mgd.core.navigation.INavigationChangedListener;
import com.arm.mgd.core.navigation.NavigationUriChangeEvent;
import com.arm.mgd.core.target.data.InterceptorExecutionState;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.io.live.InterceptorCaptureState;
import com.arm.mgd.core.target.io.live.ModifyStateInterceptorCommand;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionInterceptorStateListener;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.utils.NullUtils;
import java.lang.ref.WeakReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractInterceptorStateHandler
extends AbstractHandler
implements TargetConnectionInterceptorStateListener,
INavigationChangedListener {
    private @NonNull WeakReference<@Nullable TraceDataModel> currentModel = NullUtils.emptyWeakReference();

    public AbstractInterceptorStateHandler() {
        CoreInstance.getNavigationManager().addNavigationChangedListener((INavigationChangedListener)this);
        TargetConnectionManager.addTargetConnectionInterceptorStateListener(this);
    }

    public void dispose() {
        CoreInstance.getNavigationManager().removeNavigationChangedListener((INavigationChangedListener)this);
        super.dispose();
    }

    public void onInterceptorCaptureStateChanged(@NonNull InterceptorCaptureState oldState, @NonNull InterceptorCaptureState newState) {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public void onInterceptorStateChanged(@NonNull InterceptorExecutionState oldState, @NonNull InterceptorExecutionState newState, int processID) {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    @Override
    public void onTargetConnectionChanged(AbstractTargetConnection connection) {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public void onTargetModifyStateChanged(ModifyStateInterceptorCommand newState) {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    public void onNavigationChanged(@NonNull NavigationUriChangeEvent navigationUriChangeEvent) {
        navigationUriChangeEvent.getNewModel(newModel -> {
            if (newModel != this.currentModel.get()) {
                this.currentModel = new WeakReference<TraceDataModel>((TraceDataModel)newModel);
                this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
            }
            return null;
        });
    }

    public @Nullable TraceDataModel getCurrentModel() {
        return (TraceDataModel)this.currentModel.get();
    }
}

