/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.filterruler;

import com.arm.mgd.core.util.ListenerList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.paint.Color;
import org.eclipse.jdt.annotation.NonNull;

public final class MarkerSet
implements Observable {
    private final @NonNull SortedSet<@NonNull Number> activePositions = new TreeSet<Number>();
    private final @NonNull SimpleObjectProperty<@NonNull Color> color;
    private final @NonNull ListenerList<InvalidationListener> listenerList;
    private final @NonNull SimpleBooleanProperty visible;

    public MarkerSet(@NonNull Color color, boolean visible) {
        this.color = new SimpleObjectProperty((Object)color);
        this.visible = new SimpleBooleanProperty(visible);
        this.listenerList = new ListenerList();
    }

    public void addListener(InvalidationListener listener) {
        this.listenerList.add((Object)listener);
    }

    public synchronized void clearActivePositions() {
        if (this.activePositions.size() != 0) {
            this.activePositions.clear();
            this.notifyListeners();
        }
    }

    public @NonNull SimpleObjectProperty<@NonNull Color> colorProperty() {
        return this.color;
    }

    public @NonNull SortedSet<@NonNull Number> getActivePositions() {
        return Collections.unmodifiableSortedSet(this.activePositions);
    }

    public @NonNull Color getColor() {
        return (Color)this.color.get();
    }

    public boolean isVisible() {
        return this.visible.get();
    }

    public void removeListener(InvalidationListener listener) {
        this.listenerList.remove((Object)listener);
    }

    public synchronized void addActivePositions(@NonNull Collection<@NonNull ? extends Number> positions) {
        this.activePositions.addAll(positions);
        this.notifyListeners();
    }

    public synchronized void removeActivePositions(@NonNull Collection<@NonNull ? extends Number> positions) {
        this.activePositions.removeAll(positions);
        this.notifyListeners();
    }

    public synchronized void setActivePositions(@NonNull Collection<@NonNull ? extends Number> activePositions) {
        this.activePositions.clear();
        this.activePositions.addAll(activePositions);
        this.notifyListeners();
    }

    public void setColor(@NonNull Color color) {
        this.color.set((Object)color);
    }

    public void setVisible(boolean visible) {
        this.visible.set(visible);
    }

    public BooleanProperty visibleProperty() {
        return this.visible;
    }

    private synchronized void notifyListeners() {
        this.listenerList.forEach(l -> Platform.runLater(() -> l.invalidated((Observable)this)));
    }
}

