/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.filterruler;

import com.arm.mgd.core.util.BinarySearchList;
import com.arm.mgd.ui.filterruler.MarkerSet;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class FilterRuler
extends StackPane {
    private static final double MIN_BLOCK_HEIGHT = 1.0;
    private final Map<@NonNull MarkerSet, MarkerSetLayer> markerSetLayers;
    private final @NonNull ObservableSet<@NonNull MarkerSet> markerSets;
    private final @NonNull SimpleIntegerProperty maximumMarkerValue;
    private final @NonNull SimpleIntegerProperty minimumMarkerValue;
    private final @NonNull SimpleDoubleProperty scaleFactor = new SimpleDoubleProperty(1.0);
    private final @NonNull SimpleIntegerProperty selectedMarkerValue;
    private @Nullable Consumer<Integer> onClickConsumer;

    public FilterRuler() {
        this.minimumMarkerValue = new SimpleIntegerProperty(0);
        this.maximumMarkerValue = new SimpleIntegerProperty(0);
        this.selectedMarkerValue = new SimpleIntegerProperty(0);
        this.markerSetLayers = new HashMap<MarkerSet, MarkerSetLayer>();
        this.markerSets = (ObservableSet)NullUtils.neverNull((Object)FXCollections.observableSet(new LinkedHashSet()));
        InvalidationListener rescaleInvalidationListener = new InvalidationListener(){

            public void invalidated(Observable observable) {
                FilterRuler.this.recalculateScale();
            }
        };
        this.heightProperty().addListener(rescaleInvalidationListener);
        this.minimumMarkerValue.addListener(rescaleInvalidationListener);
        this.maximumMarkerValue.addListener(rescaleInvalidationListener);
        this.markerSets.addListener((SetChangeListener)new SetChangeListener<MarkerSet>(){

            public void onChanged(SetChangeListener.Change<? extends MarkerSet> change) {
                if (change.wasRemoved()) {
                    MarkerSet removedMarkerSet = (MarkerSet)change.getElementRemoved();
                    if (!$assertionsDisabled && removedMarkerSet == null) {
                        throw new AssertionError();
                    }
                    FilterRuler.this.removeAllMarkers(removedMarkerSet);
                }
                if (change.wasAdded()) {
                    MarkerSet addedMarkerSet = (MarkerSet)change.getElementAdded();
                    if (!$assertionsDisabled && addedMarkerSet == null) {
                        throw new AssertionError();
                    }
                    FilterRuler.this.addNewMarkerSet(addedMarkerSet);
                }
            }
        });
        this.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Consumer<Integer> localOnClickConsumer = FilterRuler.this.onClickConsumer;
                if (localOnClickConsumer == null) {
                    return;
                }
                int i = FilterRuler.this.getChildren().size() - 1;
                while (i >= 0) {
                    MarkerSetLayer layer = (MarkerSetLayer)((Object)FilterRuler.this.getChildren().get(i));
                    MouseOverRegion mouseOverRegion = layer.findMouseOverRegion((int)event.getY());
                    if (mouseOverRegion != null) {
                        localOnClickConsumer.accept(mouseOverRegion.markerIndex);
                        break;
                    }
                    --i;
                }
            }
        });
        this.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                Consumer<Integer> localOnClickConsumer = FilterRuler.this.onClickConsumer;
                if (localOnClickConsumer == null) {
                    FilterRuler.this.setCursor(Cursor.DEFAULT);
                    return;
                }
                int i = FilterRuler.this.getChildren().size() - 1;
                while (i >= 0) {
                    MarkerSetLayer layer = (MarkerSetLayer)((Object)FilterRuler.this.getChildren().get(i));
                    MouseOverRegion mouseOverRegion = layer.findMouseOverRegion((int)event.getY());
                    if (mouseOverRegion != null) {
                        FilterRuler.this.setCursor(Cursor.HAND);
                        return;
                    }
                    --i;
                }
                FilterRuler.this.setCursor(Cursor.DEFAULT);
            }
        });
    }

    public @NonNull Set<@NonNull MarkerSet> getMarkerSets() {
        return this.markerSets;
    }

    public int getMaximumMarkerValue() {
        return this.maximumMarkerValue.intValue();
    }

    public int getMinimumMarkerValue() {
        return this.minimumMarkerValue.intValue();
    }

    public double getScaleFactor() {
        return this.scaleFactor.doubleValue();
    }

    public int getSelectedMarkerValue() {
        return this.selectedMarkerValue.get();
    }

    public @NonNull ObservableSet<@NonNull MarkerSet> markerSetsProperty() {
        return this.markerSets;
    }

    public @NonNull IntegerProperty maximumMarkerValueProperty() {
        return this.maximumMarkerValue;
    }

    public @NonNull IntegerProperty minimumMarkerValueProperty() {
        return this.minimumMarkerValue;
    }

    public @NonNull ReadOnlyDoubleProperty scaleFactorProperty() {
        return this.scaleFactor;
    }

    public @NonNull IntegerProperty selectedMarkerValueProperty() {
        return this.selectedMarkerValue;
    }

    public synchronized void setMarkerSets(@NonNull Set<@NonNull MarkerSet> markerSets) {
        this.markerSets.addAll(markerSets);
        this.markerSets.retainAll(markerSets);
    }

    public void setMaximumMarkerValue(int maximumMarkerValue) {
        this.maximumMarkerValue.set(maximumMarkerValue);
    }

    public void setMinimumMarkerValue(int minimumMarkerValue) {
        this.minimumMarkerValue.set(minimumMarkerValue);
    }

    public void setSelectedMarkerValue(int selectedMarkerValue) {
        this.selectedMarkerValue.set(selectedMarkerValue);
    }

    private synchronized void addNewMarkerSet(@NonNull MarkerSet addedMarkerSet) {
        assert (!this.markerSetLayers.containsKey(addedMarkerSet));
        this.markerSetLayers.put(addedMarkerSet, new MarkerSetLayer(addedMarkerSet));
    }

    private void recalculateScale() {
        int minValue = this.getMinimumMarkerValue();
        int maxValue = this.getMaximumMarkerValue();
        int range = maxValue - minValue;
        double height = this.getHeight();
        if (range < 0 || height < 1.0) {
            this.scaleFactor.set(0.0);
            return;
        }
        this.scaleFactor.set((height - 1.0) / (double)range);
    }

    private synchronized void removeAllMarkers(@NonNull MarkerSet removedMarkerSet) {
        assert (this.markerSetLayers.containsKey(removedMarkerSet));
        MarkerSetLayer layer = this.markerSetLayers.remove(removedMarkerSet);
        if (layer != null) {
            layer.remove();
        }
    }

    public void setOnClickConsumer(Consumer<Integer> onClickConsumer) {
        this.onClickConsumer = onClickConsumer;
    }

    private class MarkerSetLayer
    extends Canvas {
        private final @NonNull MarkerSet markerSet;
        private final @NonNull List<@NonNull MouseOverRegion> mouseOverRegions;
        private final @NonNull AtomicBoolean pendingRedraw = new AtomicBoolean(false);
        private final @NonNull InvalidationListener redrawInvalidationListener;

        public MarkerSetLayer(MarkerSet markerSet) {
            this.mouseOverRegions = new ArrayList<MouseOverRegion>();
            this.markerSet = markerSet;
            this.redrawInvalidationListener = new InvalidationListener(){

                public void invalidated(Observable observable) {
                    MarkerSetLayer.this.redrawMarkers();
                }
            };
            FilterRuler.this.selectedMarkerValue.addListener(this.redrawInvalidationListener);
            FilterRuler.this.scaleFactor.addListener(this.redrawInvalidationListener);
            markerSet.addListener(this.redrawInvalidationListener);
            markerSet.visibleProperty().addListener(this.redrawInvalidationListener);
            markerSet.colorProperty().addListener(this.redrawInvalidationListener);
            this.redrawMarkers();
            this.widthProperty().bind((ObservableValue)FilterRuler.this.widthProperty());
            this.heightProperty().bind((ObservableValue)FilterRuler.this.heightProperty());
            FilterRuler.this.getChildren().add((Object)this);
            this.setMouseTransparent(true);
        }

        public void remove() {
            FilterRuler.this.getChildren().remove((Object)this);
            FilterRuler.this.scaleFactor.removeListener(this.redrawInvalidationListener);
            FilterRuler.this.selectedMarkerValue.removeListener(this.redrawInvalidationListener);
            this.markerSet.colorProperty().removeListener(this.redrawInvalidationListener);
            this.markerSet.visibleProperty().removeListener(this.redrawInvalidationListener);
            this.markerSet.removeListener(this.redrawInvalidationListener);
        }

        private synchronized void doPendingRedraw() {
            try {
                GraphicsContext gc = this.getGraphicsContext2D();
                int minMarkerValue = FilterRuler.this.getMinimumMarkerValue();
                int maxMarkerValue = FilterRuler.this.getMaximumMarkerValue();
                int markerValueRange = maxMarkerValue - minMarkerValue;
                double width = this.getWidth();
                double height = this.getHeight();
                double scale = FilterRuler.this.getScaleFactor();
                gc.clearRect(0.0, 0.0, width, height);
                gc.setFill((Paint)Color.TRANSPARENT);
                gc.fill();
                gc.setFill((Paint)this.markerSet.getColor());
                this.mouseOverRegions.clear();
                @NonNull SortedSet<@NonNull Number> activePositions = this.markerSet.getActivePositions();
                if (this.markerSet.isVisible() && scale > 0.0 && activePositions.size() > 0) {
                    int dirtyYPos = -1;
                    int lastMarkerInBlock = -1;
                    int firstMarkerInBlock = -1;
                    int highestMarker = activePositions.last().intValue();
                    for (Number marker : activePositions) {
                        boolean occluded;
                        int markerPos = marker.intValue() - minMarkerValue;
                        if (markerPos < 0 || markerPos > markerValueRange) continue;
                        boolean endOfBlockFound = false;
                        if (firstMarkerInBlock == -1) {
                            firstMarkerInBlock = markerPos;
                            lastMarkerInBlock = markerPos;
                        } else if (markerPos == lastMarkerInBlock + 1) {
                            lastMarkerInBlock = markerPos;
                        } else {
                            endOfBlockFound = true;
                        }
                        if (lastMarkerInBlock == highestMarker - minMarkerValue) {
                            endOfBlockFound = true;
                        }
                        int yStart = (int)((double)firstMarkerInBlock * scale);
                        int yEnd = (int)Math.max((double)(lastMarkerInBlock - firstMarkerInBlock) * scale, 1.0) + yStart;
                        boolean bl = occluded = yEnd <= (yStart = Math.max(dirtyYPos, yStart));
                        if (!occluded) {
                            this.mouseOverRegions.add(this.createRegion(markerPos, marker.intValue(), scale));
                        }
                        if (!endOfBlockFound) continue;
                        firstMarkerInBlock = markerPos;
                        lastMarkerInBlock = markerPos;
                        if (occluded) continue;
                        gc.fillRect(0.0, (double)yStart, width, (double)(yEnd - yStart));
                        dirtyYPos = yEnd;
                    }
                }
            }
            finally {
                this.pendingRedraw.set(false);
            }
        }

        private @NonNull MouseOverRegion createRegion(int adjustedMarkerPosition, int originalMarkerPosition, double scale) {
            int yStart = (int)((double)adjustedMarkerPosition * scale);
            int yEnd = (int)Math.max(1.0 * scale, 1.0) + yStart;
            return new MouseOverRegion(yStart, yEnd, originalMarkerPosition);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private @Nullable MouseOverRegion findMouseOverRegion(int yPos) {
            if (!this.pendingRedraw.get()) {
                MarkerSetLayer markerSetLayer = this;
                synchronized (markerSetLayer) {
                    return (MouseOverRegion)BinarySearchList.usingComparator(this.mouseOverRegions, that -> that.comparePosition(yPos));
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void redrawMarkers() {
            if (this.pendingRedraw.compareAndSet(false, true)) {
                MarkerSetLayer markerSetLayer = this;
                synchronized (markerSetLayer) {
                    Platform.runLater(() -> this.doPendingRedraw());
                }
            }
        }
    }

    private static class MouseOverRegion {
        public final int fromY;
        public final int markerIndex;
        public final int toY;

        public MouseOverRegion(int fromY, int toY, int markerIndex) {
            assert (fromY < toY);
            this.fromY = fromY;
            this.toY = toY;
            this.markerIndex = markerIndex;
        }

        public int comparePosition(int yPos) {
            if (this.toY <= yPos) {
                return -1;
            }
            if (this.fromY > yPos) {
                return 1;
            }
            return 0;
        }
    }
}

