/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.editorinput;

import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.ICoreLoggingSource;
import com.arm.mgd.ui.targetconn.AbstractTargetConnection;
import com.arm.mgd.ui.targetconn.TargetConnectionManager;
import com.arm.mgd.ui.utils.SimpleCoreProgressMonitor;
import com.arm.mgd.ui.views.TraceEditor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class TargetEditorInput {
    public static final @NonNull ISchedulingRule EDITOR_CLOSE_SCHEDULING_RULE = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private final @NonNull AbstractTargetConnection targetConnection;
    private final @NonNull ProxyTargetEditor proxyEditor;

    public static void openEditor(final @NonNull IWorkbenchWindow window, final @NonNull AbstractTargetConnection targetConnection) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage activePage = window.getActivePage();
                    TargetEditorInput editorInput = new TargetEditorInput(targetConnection);
                    activePage.openEditor((IEditorInput)editorInput.proxyEditor, TraceEditor.getID());
                }
                catch (PartInitException e) {
                    CoreLogging.severe((ICoreLoggingSource)targetConnection, (String)("Connection '" + targetConnection.getName() + "' could not be opened: " + e.getMessage()));
                }
            }
        });
    }

    private TargetEditorInput(@NonNull AbstractTargetConnection targetConnection) {
        this.targetConnection = targetConnection;
        this.proxyEditor = new ProxyTargetEditor(this);
    }

    public boolean canSave() {
        return this.targetConnection.getStorageFile() != null && this.targetConnection.getStorageFile().isFile();
    }

    public File getCurrentFile() {
        return this.targetConnection.getStorageFile();
    }

    public @NonNull String getName() {
        return this.targetConnection.getName();
    }

    public boolean isDirty() {
        return this.targetConnection.getTarget().hasBeenModified();
    }

    public void release() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                SimpleCoreProgressMonitor coreMonitor = new SimpleCoreProgressMonitor(monitor);
                coreMonitor.setTask("Disconnecting from device", 100);
                CoreLogging.info((ICoreLoggingSource)TargetEditorInput.this.targetConnection, (String)"Starting close...");
                if (TargetEditorInput.this.targetConnection.isActive()) {
                    TargetEditorInput.this.targetConnection.disconnect();
                }
                coreMonitor.incProgress(20);
                monitor.subTask("Closing the target");
                TargetEditorInput.this.targetConnection.close(new SimpleCoreProgressMonitor(monitor));
                coreMonitor.incProgress(30);
                CoreLogging.info((ICoreLoggingSource)TargetEditorInput.this.targetConnection, (String)"Completed close...");
                TargetConnectionManager.releaseConnection(TargetEditorInput.this.targetConnection, coreMonitor);
                TargetEditorInput.this.proxyEditor.editor = null;
                monitor.done();
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InterruptedException | InvocationTargetException e) {
            CoreLogging.severe((ICoreLoggingSource)this.targetConnection, (Throwable)e, null);
        }
    }

    public void saveAs(@NonNull IProgressMonitor progressMonitor, @NonNull File newFile) throws IOException {
        this.targetConnection.saveCurrentModelToFile(progressMonitor, newFile);
    }

    public @NonNull AbstractTargetConnection getTargetConnection() {
        return this.targetConnection;
    }

    public static class ProxyTargetEditor
    implements IEditorInput {
        private final @NonNull String name;
        private @Nullable TargetEditorInput editor;

        private ProxyTargetEditor(@NonNull TargetEditorInput editorInput) {
            this.name = editorInput.getTargetConnection().getName();
            this.editor = editorInput;
        }

        public boolean exists() {
            return true;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getToolTipText() {
            if (this.editor != null) {
                return this.editor.getTargetConnection().getToolTipText();
            }
            return "";
        }

        public @Nullable TargetEditorInput getEditor() {
            return this.editor;
        }
    }
}

