/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs.replayoverridewizard;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureUnitAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.texture.TextureOverride;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.ui.Activator;
import com.arm.mgd.ui.SWTImageDataUtils;
import com.arm.mgd.ui.dialogs.FrameReplayOverrideWizard;
import com.arm.mgd.ui.dialogs.replayoverridewizard.AbstractSecondPage;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public class SelectTextureAssetPage
extends AbstractSecondPage<GlTextureAsset> {
    private GlTextureAsset defaultSelection;
    private TextureOverride overrideToEdit = null;
    public static final @Nullable IByteDataProvider TEXTURE_COORDINATE_256 = SelectTextureAssetPage.createOverrideTexture();
    private final TraceDataModel model;
    private final @NonNull TraceStateSnapshot latestSnapshot;

    public SelectTextureAssetPage(FrameReplayOverrideWizard parent, @NonNull String label, @NonNull TraceStateSnapshot latestSnapshot, @NonNull TraceStateSnapshot selectedSnapshot, @NonNull Map<String, GlTextureAsset> dataSource) {
        super("Select Override Type", parent, label, dataSource);
        Set boundTextures;
        this.model = selectedSnapshot.getModel();
        this.latestSnapshot = latestSnapshot;
        AssetTable textureUnitAssetTable = selectedSnapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_UNIT_TRAITS.SPEC);
        StateItem activeTextureState = selectedSnapshot.getStateItemBySpec(KapiSpec.GLES.states.GL_ACTIVE_TEXTURE);
        GlTextureAsset textureAsset = null;
        AbstractConstantOrAliasSpecExtended textureUnitId = (AbstractConstantOrAliasSpecExtended)activeTextureState.getValue()[0].value;
        GlTextureUnitAsset textureUnit = (GlTextureUnitAsset)textureUnitAssetTable.get(GlTextureUnitAsset.convertTextureUnitEnumToTextureUnitId((AbstractConstantOrAliasSpecExtended)((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)textureUnitId))));
        if (textureUnit != null && !(boundTextures = textureUnit.getAllBoundTextures()).isEmpty()) {
            textureAsset = (GlTextureAsset)boundTextures.iterator().next();
        }
        this.setDefault((IAssetItem)this.getDataSource().values().iterator().next());
        if (dataSource.size() > 1 && this.getDataSource().values().contains(textureAsset)) {
            this.setDefault((IAssetItem)textureAsset);
        }
    }

    private static @Nullable IByteDataProvider createOverrideTexture() {
        Image image = Activator.getImageDescriptor("/resources/textureCoordinate_256.png").createImage();
        byte @Nullable [] bytes = SWTImageDataUtils.extractByteInformation(image.getImageData());
        return bytes != null ? IByteDataProvider.createMemoryProvider((byte[])bytes) : null;
    }

    @Override
    public List<AbstractFrameOverride> createOverride() {
        ArrayList<AbstractFrameOverride> result = new ArrayList<AbstractFrameOverride>();
        result.add((AbstractFrameOverride)new TextureOverride(TEXTURE_COORDINATE_256, ((GlTextureAsset)NullUtils.neverNull((Object)((GlTextureAsset)this.getSelectedValue()))).getId().longValue()));
        return result;
    }

    @Override
    public void editOverride() {
        TextureOverride overrideToEdit = this.overrideToEdit;
        if (overrideToEdit != null) {
            this.model.getCurrentActiveOverrides().remove((AbstractFrameOverride)overrideToEdit);
            this.model.getCurrentActiveOverrides().add((AbstractFrameOverride)new TextureOverride(overrideToEdit.getTextureData(), ((GlTextureAsset)NullUtils.neverNull((Object)((GlTextureAsset)this.getSelectedValue()))).getId().longValue()));
        }
    }

    @Override
    public GlTextureAsset getDefaultSelection() {
        return this.defaultSelection;
    }

    @Override
    public String getAnalyticsID() {
        return "textureoverride";
    }

    @Override
    public void setDefault(IAssetItem newDefault) {
        this.defaultSelection = (GlTextureAsset)newDefault;
    }

    @Override
    public void setEditableOverride(AbstractFrameOverride afo) {
        this.overrideToEdit = (TextureOverride)afo;
        AssetTable textureTable = this.latestSnapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.TEXTURE_TRAITS.SPEC);
        IAssetItem asset = textureTable.get(this.overrideToEdit.getTextureToReplace());
        if (asset != null && asset instanceof GlTextureAsset) {
            this.setDefault(asset);
        }
    }

    @Override
    public void removeOverride() {
    }
}

