/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs.replayoverridewizard;

import com.arm.mali.mgd.editors.ShaderOverrideEditor;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.SourceProvider;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.shader.ProgramOverride;
import com.arm.mgd.core.target.data.TraceDataModel;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.ui.dialogs.FrameReplayOverrideWizard;
import com.arm.mgd.ui.dialogs.replayoverridewizard.AbstractSecondPage;
import com.arm.mgd.ui.editorinput.SourceEditorInput;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ModifyProgramAssetPage
extends AbstractSecondPage<GlProgramAsset> {
    private GlProgramAsset defaultSelection;
    private ProgramOverride overrideToEdit = null;
    private final TraceStateSnapshot selectionSnapshot;

    public ModifyProgramAssetPage(FrameReplayOverrideWizard parent, AbstractSecondPage.Mode mode, @NonNull TraceStateSnapshot selectionSnapshot, @NonNull Map<String, GlProgramAsset> dataSource) {
        super("Select Override Type", parent, ModifyProgramAssetPage.getProgramAssetItemsLabelText(mode), dataSource);
        this.selectionSnapshot = selectionSnapshot;
        this.setDefault((IAssetItem)this.getDataSource().values().iterator().next());
        if (dataSource.size() > 1) {
            GlProgramAsset currentProgram = GlProgramHelper.getCurrentNormalProgramAsset((TraceStateSnapshot)selectionSnapshot);
            if (this.getDataSource().values().contains(currentProgram)) {
                this.setDefault((IAssetItem)currentProgram);
            }
        }
    }

    private static @NonNull String getProgramAssetItemsLabelText(AbstractSecondPage.Mode mode) {
        String message = "";
        switch (mode) {
            case ADD: {
                message = "Select a program to override:";
                break;
            }
            case REMOVE: {
                message = "Remove the program override:";
                break;
            }
            case EDIT: {
                message = "Edit the program override:";
                break;
            }
        }
        return message;
    }

    @Override
    public List<AbstractFrameOverride> createOverride() {
        ArrayList<AbstractFrameOverride> result = new ArrayList<AbstractFrameOverride>();
        ProgramOverride po = new ProgramOverride((GlProgramAsset)NullUtils.neverNull((Object)((GlProgramAsset)this.getSelectedValue())));
        result.add((AbstractFrameOverride)po);
        ModifyProgramAssetPage.openEditor(po, this.selectionSnapshot.getModel());
        return result;
    }

    @Override
    protected GlProgramAsset getDefaultSelection() {
        return this.defaultSelection;
    }

    @Override
    public String getAnalyticsID() {
        return "editshader";
    }

    @Override
    public void setDefault(IAssetItem newDefault) {
        this.defaultSelection = (GlProgramAsset)newDefault;
    }

    @Override
    public void editOverride() {
        ProgramOverride overrideToEdit;
        GlProgramAsset selection = (GlProgramAsset)this.getSelectedValue();
        if (selection != null && (overrideToEdit = this.overrideToEdit) != null) {
            this.selectionSnapshot.getModel().getCurrentActiveOverrides().remove((AbstractFrameOverride)overrideToEdit);
            ProgramOverride newOverride = new ProgramOverride(selection);
            newOverride.getNewFragmentShader().setSource(overrideToEdit.getNewFragmentShader().getSource());
            newOverride.getNewVertexShader().setSource(overrideToEdit.getNewVertexShader().getSource());
            this.selectionSnapshot.getModel().getCurrentActiveOverrides().add((AbstractFrameOverride)newOverride);
            ModifyProgramAssetPage.openEditor(newOverride, this.selectionSnapshot.getModel());
        }
    }

    public static void openEditor(@NonNull ProgramOverride po, @NonNull TraceDataModel model) {
        SourceProvider vertexSourceAsset = po.getNewVertexShader();
        SourceProvider fragmentSourceAsset = po.getNewFragmentShader();
        SourceEditorInput vertexEditorInput = new SourceEditorInput(vertexSourceAsset, model);
        SourceEditorInput fragmentEditorInput = new SourceEditorInput(fragmentSourceAsset, model);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)vertexEditorInput, ShaderOverrideEditor.getID());
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)fragmentEditorInput, ShaderOverrideEditor.getID());
        }
        catch (PartInitException e) {
            CoreLogging.warning(null, (Throwable)e, null);
        }
    }

    @Override
    public void setEditableOverride(AbstractFrameOverride afo) {
        this.overrideToEdit = (ProgramOverride)afo;
        this.setDefault((IAssetItem)this.overrideToEdit.getProgram());
    }

    @Override
    public void removeOverride() {
        this.selectionSnapshot.getModel().getCurrentActiveOverrides().remove(FrameOverrides.OverrideType.PROGRAM_OVERRIDE, (IAssetItem)NullUtils.neverNull((Object)((GlProgramAsset)this.getSelectedValue())));
    }
}

