/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.ui.dialogs.replayoverridewizard;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.replay.AbstractFrameOverride;
import com.arm.mgd.core.replay.FrameOverrides;
import com.arm.mgd.core.replay.shader.ForcePrecisionModeOverride;
import com.arm.mgd.core.replay.shader.PrecisionModeModifier;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.ui.dialogs.FrameReplayOverrideWizard;
import com.arm.mgd.ui.dialogs.replayoverridewizard.AbstractSecondPage;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ModifyPrecisionOverridePage
extends AbstractSecondPage<GlProgramAsset> {
    private GlProgramAsset defaultSelection;
    private PrecisionModeModifier.PrecisionModes precisionMode;
    private ForcePrecisionModeOverride overrideToEdit = null;
    private boolean allShadersOptionEnabled = true;
    private final @NonNull TraceStateSnapshot selectionSnapshot;

    public ModifyPrecisionOverridePage(FrameReplayOverrideWizard parent, AbstractSecondPage.Mode mode, @NonNull TraceStateSnapshot selectionSnapshot, @NonNull Map<String, GlProgramAsset> dataSource) {
        super("Select Override Type", parent, ModifyPrecisionOverridePage.getProgramAssetItemsLabelText(mode), ModifyPrecisionOverridePage.filterInvalid(dataSource));
        this.selectionSnapshot = selectionSnapshot;
        this.setDefault((IAssetItem)this.getDataSource().values().iterator().next());
        if (dataSource.size() > 1) {
            GlProgramAsset currentProgram = GlProgramHelper.getCurrentNormalProgramAsset((TraceStateSnapshot)selectionSnapshot);
            if (this.getDataSource().values().contains(currentProgram)) {
                this.setDefault((IAssetItem)currentProgram);
            }
        }
    }

    private static @NonNull String getProgramAssetItemsLabelText(AbstractSecondPage.Mode mode) {
        String message = "";
        switch (mode) {
            case ADD: {
                message = "Override precision mode:";
                break;
            }
            case REMOVE: {
                message = "Remove the precision mode override:";
                break;
            }
            case EDIT: {
                message = "Edit the precision mode override:";
                break;
            }
        }
        return message;
    }

    private static @NonNull Map<String, GlProgramAsset> filterInvalid(@NonNull Map<String, GlProgramAsset> labelAssetMap) {
        Iterator<Map.Entry<String, GlProgramAsset>> iterator = labelAssetMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, GlProgramAsset> item = iterator.next();
            try {
                if (ModifyPrecisionOverridePage.factory(item.getValue(), PrecisionModeModifier.PrecisionModes.HIGHP) != null) continue;
                iterator.remove();
            }
            catch (Exception e) {
                iterator.remove();
            }
        }
        return labelAssetMap;
    }

    @Override
    public List<AbstractFrameOverride> createOverride() {
        ArrayList<AbstractFrameOverride> result = new ArrayList<AbstractFrameOverride>();
        if (this.isSelectedAll()) {
            for (Map.Entry entry : this.getDataSource().entrySet()) {
                result.add((AbstractFrameOverride)ModifyPrecisionOverridePage.factory((GlProgramAsset)entry.getValue(), this.precisionMode));
            }
        } else {
            result.add((AbstractFrameOverride)ModifyPrecisionOverridePage.factory((GlProgramAsset)this.getSelectedValue(), this.precisionMode));
        }
        return result;
    }

    private static ForcePrecisionModeOverride factory(GlProgramAsset program, PrecisionModeModifier.PrecisionModes precisionMode) {
        assert (program != null);
        assert (precisionMode != null);
        if (program.getLinkedShader(KapiSpec.GLES.constants.GL_VERTEX_SHADER) == null || program.getLinkedShader(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER) == null) {
            return null;
        }
        return new ForcePrecisionModeOverride(program, precisionMode);
    }

    @Override
    protected GlProgramAsset getDefaultSelection() {
        return this.defaultSelection;
    }

    @Override
    protected void createAdditionalControlsBefore(Composite container) {
        final Combo combo = this.createComboBox(container, "Select precision mode:");
        PrecisionModeModifier.PrecisionModes[] precisionModesArray = PrecisionModeModifier.PrecisionModes.values();
        int n = precisionModesArray.length;
        int n2 = 0;
        while (n2 < n) {
            PrecisionModeModifier.PrecisionModes aPrecisionMode = precisionModesArray[n2];
            combo.add(aPrecisionMode.modeString);
            combo.setData(aPrecisionMode.modeString, (Object)aPrecisionMode);
            ++n2;
        }
        combo.select(PrecisionModeModifier.PrecisionModes.HIGHP.ordinal());
        this.setPrecisionMode(PrecisionModeModifier.PrecisionModes.HIGHP);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                ModifyPrecisionOverridePage.this.setPrecisionMode((PrecisionModeModifier.PrecisionModes)combo.getData(combo.getText()));
            }

            public void widgetSelected(SelectionEvent event) {
                this.widgetDefaultSelected(event);
            }
        });
    }

    protected void setPrecisionMode(PrecisionModeModifier.PrecisionModes precisionMode) {
        this.precisionMode = precisionMode;
        this.setPageComplete();
    }

    @Override
    protected boolean getPageComplete() {
        return super.getPageComplete() && this.precisionMode != null;
    }

    @Override
    protected boolean allowAllOverride() {
        return this.allShadersOptionEnabled;
    }

    @Override
    public String getAnalyticsID() {
        return "forceprecision";
    }

    @Override
    public void setDefault(IAssetItem newDefault) {
        this.defaultSelection = (GlProgramAsset)newDefault;
    }

    @Override
    public void editOverride() {
        ForcePrecisionModeOverride overrideToEdit = this.overrideToEdit;
        if (overrideToEdit != null) {
            this.selectionSnapshot.getModel().getCurrentActiveOverrides().remove((AbstractFrameOverride)overrideToEdit);
            this.selectionSnapshot.getModel().getCurrentActiveOverrides().add((AbstractFrameOverride)new ForcePrecisionModeOverride((GlProgramAsset)NullUtils.neverNull((Object)((GlProgramAsset)this.getSelectedValue())), (PrecisionModeModifier.PrecisionModes)NullUtils.neverNull((Object)this.precisionMode)));
        }
    }

    @Override
    public void setEditableOverride(AbstractFrameOverride afo) {
        this.allShadersOptionEnabled = false;
        this.overrideToEdit = (ForcePrecisionModeOverride)afo;
        this.setDefault((IAssetItem)this.overrideToEdit.getProgram());
        this.setPrecisionMode(this.overrideToEdit.getPrecisionMode());
    }

    @Override
    public void removeOverride() {
        if (this.isSelectedAll()) {
            for (Map.Entry entry : this.getDataSource().entrySet()) {
                this.selectionSnapshot.getModel().getCurrentActiveOverrides().remove(FrameOverrides.OverrideType.FORCE_PRECISION_OVERRIDE, (IAssetItem)NullUtils.neverNull((Object)((GlProgramAsset)entry.getValue())));
            }
        } else {
            this.selectionSnapshot.getModel().getCurrentActiveOverrides().remove(FrameOverrides.OverrideType.FORCE_PRECISION_OVERRIDE, (IAssetItem)NullUtils.neverNull((Object)((GlProgramAsset)this.getSelectedValue())));
        }
    }
}

